/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.put.sender;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.nifi.logging.ProcessorLog;

public abstract class ChannelSender {
    protected final int port;
    protected final String host;
    protected final int maxSendBufferSize;
    protected final ProcessorLog logger;
    protected volatile int timeout = 10000;
    protected volatile long lastUsed;

    public ChannelSender(String host, int port, int maxSendBufferSize, ProcessorLog logger) {
        this.port = port;
        this.host = host;
        this.maxSendBufferSize = maxSendBufferSize;
        this.logger = logger;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public abstract void open() throws IOException;

    public void send(String message, Charset charset) throws IOException {
        byte[] bytes = message.getBytes(charset);
        this.send(bytes);
    }

    public void send(byte[] data) throws IOException {
        this.write(data);
        this.lastUsed = System.currentTimeMillis();
    }

    protected abstract void write(byte[] var1) throws IOException;

    public abstract boolean isConnected();

    public abstract void close();
}

