/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.put.sender;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.util.put.sender.ChannelSender;

public class DatagramChannelSender
extends ChannelSender {
    private DatagramChannel channel;

    public DatagramChannelSender(String host, int port, int maxSendBufferSize, ProcessorLog logger) {
        super(host, port, maxSendBufferSize, logger);
    }

    @Override
    public void open() throws IOException {
        if (this.channel == null) {
            this.channel = DatagramChannel.open();
            if (this.maxSendBufferSize > 0) {
                this.channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.maxSendBufferSize);
                int actualSendBufSize = this.channel.getOption(StandardSocketOptions.SO_SNDBUF);
                if (actualSendBufSize < this.maxSendBufferSize) {
                    this.logger.warn("Attempted to set Socket Send Buffer Size to " + this.maxSendBufferSize + " bytes but could only set to " + actualSendBufSize + "bytes. You may want to " + "consider changing the Operating System's maximum receive buffer");
                }
            }
        }
        if (!this.channel.isConnected()) {
            this.channel.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port));
        }
    }

    @Override
    protected void write(byte[] data) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        while (buffer.hasRemaining()) {
            this.channel.write(buffer);
        }
    }

    @Override
    public boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.channel);
        this.channel = null;
    }
}

