/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.put.sender;

import java.io.Closeable;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.util.put.sender.SocketChannelSender;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;

public class SSLSocketChannelSender
extends SocketChannelSender {
    private SSLSocketChannel sslChannel;
    private SSLContext sslContext;

    public SSLSocketChannelSender(String host, int port, int maxSendBufferSize, SSLContext sslContext, ProcessorLog logger) {
        super(host, port, maxSendBufferSize, logger);
        this.sslContext = sslContext;
    }

    @Override
    public void open() throws IOException {
        if (this.sslChannel == null) {
            super.open();
            this.sslChannel = new SSLSocketChannel(this.sslContext, this.channel, true);
        }
        this.sslChannel.setTimeout(this.timeout);
        this.sslChannel.connect();
    }

    @Override
    protected void write(byte[] data) throws IOException {
        this.sslChannel.write(data);
    }

    @Override
    public boolean isConnected() {
        return this.sslChannel != null && !this.sslChannel.isClosed();
    }

    @Override
    public void close() {
        super.close();
        IOUtils.closeQuietly((Closeable)this.sslChannel);
        this.sslChannel = null;
    }
}

