/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.record.path.property;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.record.path.RecordPathResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;

public final class RecordPathPropertyUtil {
    private static final String NULL_VALUE = "null";
    private static final Pattern RECORD_PATH_PATTERN = Pattern.compile("@\\{(/.*?)\\}");

    private RecordPathPropertyUtil() {
    }

    public static String resolvePropertyValue(String propertyValue, Record record) {
        if (propertyValue != null && !propertyValue.isBlank()) {
            Matcher matcher = RECORD_PATH_PATTERN.matcher(propertyValue);
            if (matcher.matches()) {
                return RecordPathPropertyUtil.resolveRecordState(matcher.group(1), record);
            }
            return propertyValue;
        }
        return null;
    }

    private static String resolveRecordState(String pathValue, Record record) {
        RecordPathResult result;
        List<FieldValue> fieldValues;
        RecordPath recordPath = RecordPath.compile((String)pathValue);
        FieldValue fieldValue = RecordPathPropertyUtil.getMatchingFieldValue(recordPath, fieldValues = (result = recordPath.evaluate(record)).getSelectedFields().collect(Collectors.toList()));
        if (fieldValue.getValue() == null || fieldValue.getValue() == NULL_VALUE) {
            return null;
        }
        return RecordPathPropertyUtil.getFieldValue(recordPath, fieldValue);
    }

    private static FieldValue getMatchingFieldValue(RecordPath recordPath, List<FieldValue> resultList) {
        if (resultList.isEmpty()) {
            throw new ProcessException(String.format("Evaluated RecordPath [%s] against Record but got no results", recordPath));
        }
        if (resultList.size() > 1) {
            throw new ProcessException(String.format("Evaluated RecordPath [%s] against Record and received multiple distinct results [%s]", recordPath, resultList));
        }
        return resultList.get(0);
    }

    private static String getFieldValue(RecordPath recordPath, FieldValue fieldValue) {
        ChoiceDataType choiceDataType;
        List possibleTypes;
        RecordFieldType fieldType = fieldValue.getField().getDataType().getFieldType();
        if (fieldType == RecordFieldType.RECORD || fieldType == RecordFieldType.ARRAY || fieldType == RecordFieldType.MAP) {
            throw new ProcessException(String.format("The provided RecordPath [%s] points to a [%s] type value", recordPath, fieldType));
        }
        if (fieldType == RecordFieldType.CHOICE && (possibleTypes = (choiceDataType = (ChoiceDataType)fieldValue.getField().getDataType()).getPossibleSubTypes()).stream().anyMatch(type -> type.getFieldType() == RecordFieldType.RECORD)) {
            throw new ProcessException(String.format("The provided RecordPath [%s] points to a [CHOICE] type value with Record subtype", recordPath));
        }
        return String.valueOf(fieldValue.getValue());
    }
}

