/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.text.DateFormat;
import java.util.function.Supplier;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public abstract class AbstractCSVRecordReader
implements RecordReader {
    protected final ComponentLog logger;
    protected final boolean hasHeader;
    protected final boolean ignoreHeader;
    protected final Supplier<DateFormat> LAZY_DATE_FORMAT;
    protected final Supplier<DateFormat> LAZY_TIME_FORMAT;
    protected final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;
    protected final String dateFormat;
    protected final String timeFormat;
    protected final String timestampFormat;
    protected final RecordSchema schema;

    AbstractCSVRecordReader(ComponentLog logger, RecordSchema schema, boolean hasHeader, boolean ignoreHeader, String dateFormat, String timeFormat, String timestampFormat) {
        this.logger = logger;
        this.schema = schema;
        this.hasHeader = hasHeader;
        this.ignoreHeader = ignoreHeader;
        if (dateFormat == null || dateFormat.isEmpty()) {
            this.dateFormat = null;
            this.LAZY_DATE_FORMAT = null;
        } else {
            this.dateFormat = dateFormat;
            this.LAZY_DATE_FORMAT = () -> DataTypeUtils.getDateFormat((String)dateFormat);
        }
        if (timeFormat == null || timeFormat.isEmpty()) {
            this.timeFormat = null;
            this.LAZY_TIME_FORMAT = null;
        } else {
            this.timeFormat = timeFormat;
            this.LAZY_TIME_FORMAT = () -> DataTypeUtils.getDateFormat((String)timeFormat);
        }
        if (timestampFormat == null || timestampFormat.isEmpty()) {
            this.timestampFormat = null;
            this.LAZY_TIMESTAMP_FORMAT = null;
        } else {
            this.timestampFormat = timestampFormat;
            this.LAZY_TIMESTAMP_FORMAT = () -> DataTypeUtils.getDateFormat((String)timestampFormat);
        }
    }

    protected final Object convert(String value, DataType dataType, String fieldName) {
        if (dataType == null || value == null) {
            return value;
        }
        String trimmed = this.trim(value);
        if (trimmed.isEmpty()) {
            return null;
        }
        return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
    }

    protected final Object convertSimpleIfPossible(String value, DataType dataType, String fieldName) {
        if (dataType == null || value == null) {
            return value;
        }
        String trimmed = this.trim(value);
        if (trimmed.isEmpty()) {
            return null;
        }
        switch (dataType.getFieldType()) {
            case STRING: {
                return value;
            }
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case CHAR: 
            case SHORT: {
                if (!DataTypeUtils.isCompatibleDataType((Object)trimmed, (DataType)dataType)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
            case DATE: {
                if (!DataTypeUtils.isDateTypeCompatible((Object)trimmed, (String)this.dateFormat)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
            case TIME: {
                if (!DataTypeUtils.isTimeTypeCompatible((Object)trimmed, (String)this.timeFormat)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
            case TIMESTAMP: {
                if (!DataTypeUtils.isTimestampTypeCompatible((Object)trimmed, (String)this.timestampFormat)) break;
                return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
        }
        return value;
    }

    private String trim(String value) {
        return value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

