/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.nifi.csv.AbstractCSVRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class CSVRecordReader
extends AbstractCSVRecordReader {
    private final CSVParser csvParser;
    private List<RecordField> recordFields;

    public CSVRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, CSVFormat csvFormat, boolean hasHeader, boolean ignoreHeader, String dateFormat, String timeFormat, String timestampFormat, String encoding) throws IOException {
        super(logger, schema, hasHeader, ignoreHeader, dateFormat, timeFormat, timestampFormat);
        CSVFormat withHeader;
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(in), encoding);
        if (hasHeader) {
            withHeader = csvFormat.withSkipHeaderRecord();
            withHeader = ignoreHeader ? withHeader.withHeader(schema.getFieldNames().toArray(new String[0])) : withHeader.withFirstRecordAsHeader();
        } else {
            withHeader = csvFormat.withHeader(schema.getFieldNames().toArray(new String[0]));
        }
        this.csvParser = new CSVParser((Reader)reader, withHeader);
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        try {
            RecordSchema schema = this.getSchema();
            List<RecordField> recordFields = this.getRecordFields();
            int numFieldNames = recordFields.size();
            Iterator iterator = this.csvParser.iterator();
            if (iterator.hasNext()) {
                CSVRecord csvRecord = (CSVRecord)iterator.next();
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(recordFields.size() * 2);
                for (int i = 0; i < csvRecord.size(); ++i) {
                    String rawValue = csvRecord.get(i);
                    if (i >= numFieldNames) {
                        if (dropUnknownFields) continue;
                        values.put("unknown_field_index_" + i, rawValue);
                        continue;
                    }
                    RecordField recordField = recordFields.get(i);
                    String rawFieldName = recordField.getFieldName();
                    DataType dataType = recordField.getDataType();
                    Object value = coerceTypes ? this.convert(rawValue, dataType, rawFieldName) : this.convertSimpleIfPossible(rawValue, dataType, rawFieldName);
                    values.put(rawFieldName, value);
                }
                return new MapRecord(schema, values, coerceTypes, dropUnknownFields);
            }
        }
        catch (Exception e) {
            throw new MalformedRecordException("Error while getting next record. Root cause: " + Throwables.getRootCause((Throwable)e), (Throwable)e);
        }
        return null;
    }

    private List<RecordField> getRecordFields() {
        if (this.recordFields != null) {
            return this.recordFields;
        }
        TreeMap sortedMap = new TreeMap();
        for (Map.Entry entry : this.csvParser.getHeaderMap().entrySet()) {
            sortedMap.put(entry.getValue(), entry.getKey());
        }
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        ArrayList rawFieldNames = new ArrayList(sortedMap.values());
        for (String rawFieldName : rawFieldNames) {
            Optional option = this.schema.getField(rawFieldName);
            if (option.isPresent()) {
                fields.add((RecordField)option.get());
                continue;
            }
            fields.add(new RecordField(rawFieldName, RecordFieldType.STRING.getDataType()));
        }
        this.recordFields = fields;
        return fields;
    }

    public void close() throws IOException {
        this.csvParser.close();
    }
}

