/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.io.BinaryEncoder;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.WriteAvroResultWithExternalSchema;
import org.apache.nifi.avro.WriteAvroResultWithSchema;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SchemaRegistryRecordSetWriter;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"avro", "result", "set", "writer", "serializer", "record", "recordset", "row"})
@CapabilityDescription(value="Writes the contents of a RecordSet in Binary Avro format.")
public class AvroRecordSetWriter
extends SchemaRegistryRecordSetWriter
implements RecordSetWriterFactory {
    private static final Set<SchemaField> requiredSchemaFields = EnumSet.of(SchemaField.SCHEMA_TEXT, SchemaField.SCHEMA_TEXT_FORMAT);
    private static final PropertyDescriptor COMPRESSION_FORMAT = new PropertyDescriptor.Builder().name("compression-format").displayName("Compression Format").description("Compression type to use when writing Avro files. Default is None.").allowableValues((Enum[])CodecType.values()).defaultValue(CodecType.NONE.toString()).required(true).build();
    static final PropertyDescriptor ENCODER_POOL_SIZE = new PropertyDescriptor.Builder().name("encoder-pool-size").displayName("Encoder Pool Size").description("Avro Writers require the use of an Encoder. Creation of Encoders is expensive, but once created, they can be reused. This property controls the maximum number of Encoders that can be pooled and reused. Setting this value too small can result in degraded performance, but setting it higher can result in more heap being used. This property is ignored if the Avro Writer is configured with a Schema Write Strategy of 'Embed Avro Schema'.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("32").build();
    static final AllowableValue AVRO_EMBEDDED = new AllowableValue("avro-embedded", "Embed Avro Schema", "The FlowFile will have the Avro schema embedded into the content, as is typical with Avro");
    static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("cache-size").displayName("Cache Size").description("Specifies how many Schemas should be cached").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("1000").required(true).build();
    private LoadingCache<String, Schema> compiledAvroSchemaCache;
    private volatile BlockingQueue<BinaryEncoder> encoderPool;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        int cacheSize = context.getProperty(CACHE_SIZE).asInteger();
        this.compiledAvroSchemaCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build(schemaText -> new Schema.Parser().parse(schemaText));
        int capacity = context.getProperty(ENCODER_POOL_SIZE).evaluateAttributeExpressions().asInteger();
        this.encoderPool = new LinkedBlockingQueue<BinaryEncoder>(capacity);
    }

    @OnDisabled
    public void cleanup() {
        if (this.encoderPool != null) {
            this.encoderPool.clear();
        }
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema recordSchema, OutputStream out, Map<String, String> variables) throws IOException {
        String strategyValue = this.getConfigurationContext().getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        String compressionFormat = this.getConfigurationContext().getProperty(COMPRESSION_FORMAT).getValue();
        try {
            Schema avroSchema;
            try {
                Optional textOption;
                avroSchema = recordSchema.getSchemaFormat().isPresent() && ((String)recordSchema.getSchemaFormat().get()).equals("avro") ? ((textOption = recordSchema.getSchemaText()).isPresent() ? (Schema)this.compiledAvroSchemaCache.get(textOption.get()) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema)) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema);
            }
            catch (Exception e) {
                throw new SchemaNotFoundException("Failed to compile Avro Schema", (Throwable)e);
            }
            if (AVRO_EMBEDDED.getValue().equals(strategyValue)) {
                return new WriteAvroResultWithSchema(avroSchema, out, this.getCodecFactory(compressionFormat));
            }
            return new WriteAvroResultWithExternalSchema(avroSchema, recordSchema, this.getSchemaAccessWriter(recordSchema), out, this.encoderPool, this.getLogger());
        }
        catch (SchemaNotFoundException e) {
            throw new ProcessException("Could not determine the Avro Schema to use for writing the content", (Throwable)e);
        }
    }

    private CodecFactory getCodecFactory(String property) {
        CodecType type = CodecType.valueOf(property);
        switch (type) {
            case BZIP2: {
                return CodecFactory.bzip2Codec();
            }
            case DEFLATE: {
                return CodecFactory.deflateCodec((int)-1);
            }
            case LZO: {
                return CodecFactory.xzCodec((int)6);
            }
            case SNAPPY: {
                return CodecFactory.snappyCodec();
            }
        }
        return CodecFactory.nullCodec();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(COMPRESSION_FORMAT);
        properties.add(CACHE_SIZE);
        properties.add(ENCODER_POOL_SIZE);
        return properties;
    }

    protected List<AllowableValue> getSchemaWriteStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(AVRO_EMBEDDED);
        allowableValues.addAll(super.getSchemaWriteStrategyValues());
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaWriteStrategy() {
        return AVRO_EMBEDDED;
    }

    protected Set<SchemaField> getRequiredSchemaFields(ValidationContext validationContext) {
        String writeStrategyValue = validationContext.getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        if (writeStrategyValue.equalsIgnoreCase(AVRO_EMBEDDED.getValue())) {
            return requiredSchemaFields;
        }
        return super.getRequiredSchemaFields(validationContext);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        String writeStrategyValue = validationContext.getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        String compressionFormatValue = validationContext.getProperty(COMPRESSION_FORMAT).getValue();
        if (!writeStrategyValue.equalsIgnoreCase(AVRO_EMBEDDED.getValue()) && !CodecType.NONE.toString().equals(compressionFormatValue)) {
            results.add(new ValidationResult.Builder().subject(COMPRESSION_FORMAT.getName()).valid(false).explanation("Avro compression codecs are stored in the header of the Avro file and therefore requires the header to be embedded into the content.").build());
        }
        return results;
    }

    private static enum CodecType {
        BZIP2,
        DEFLATE,
        NONE,
        SNAPPY,
        LZO;

    }
}

