/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import java.util.function.Supplier;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.inference.CachedSchemaAccessStrategy;
import org.apache.nifi.schema.inference.InferSchemaAccessStrategy;
import org.apache.nifi.schema.inference.RecordSourceFactory;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.serialization.RecordSchemaCacheService;

public class SchemaInferenceUtil {
    public static final AllowableValue INFER_SCHEMA = new AllowableValue("infer-schema", "Infer Schema", "The Schema of the data will be inferred automatically when the data is read. See component Usage and Additional Details for information about how the schema is inferred.");
    public static final PropertyDescriptor SCHEMA_CACHE = new PropertyDescriptor.Builder().name("schema-inference-cache").displayName("Schema Inference Cache").description("Specifies a Schema Cache to use when inferring the schema. If not populated, the schema will be inferred each time. However, if a cache is specified, the cache will first be consulted and if the applicable schema can be found, it will be used instead of inferring the schema.").required(false).identifiesControllerService(RecordSchemaCacheService.class).build();

    public static <T> SchemaAccessStrategy getSchemaAccessStrategy(String strategy, PropertyContext context, ComponentLog logger, RecordSourceFactory<T> recordSourceFactory, Supplier<SchemaInferenceEngine<T>> inferenceSupplier, Supplier<SchemaAccessStrategy> defaultSupplier) {
        if (INFER_SCHEMA.getValue().equalsIgnoreCase(strategy)) {
            InferSchemaAccessStrategy<T> inferenceStrategy = new InferSchemaAccessStrategy<T>(recordSourceFactory, inferenceSupplier.get(), logger);
            RecordSchemaCacheService schemaCache = (RecordSchemaCacheService)context.getProperty(SCHEMA_CACHE).asControllerService(RecordSchemaCacheService.class);
            if (schemaCache == null) {
                return inferenceStrategy;
            }
            return new CachedSchemaAccessStrategy(schemaCache, inferenceStrategy, logger);
        }
        return defaultSupplier.get();
    }
}

