/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.ReaderLookup;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"lookup", "result", "set", "writer", "serializer", "record", "recordset", "row"})
@SeeAlso(value={ReaderLookup.class})
@CapabilityDescription(value="Provides a RecordSetWriterFactory that can be used to dynamically select another RecordSetWriterFactory. This service requires a variable named 'recordsetwriter.name' to be passed in when asking for a schema or record set writer, and will throw an exception if the variable is missing. The value of 'recordsetwriter.name' will be used to select the RecordSetWriterFactory that has been registered with that name. This will allow multiple RecordSetWriterFactory's to be defined and registered, and then selected dynamically at runtime by tagging flow files with the appropriate 'recordsetwriter.name' variable.")
@DynamicProperty(name="Name of the RecordSetWriter", value="A RecordSetWriterFactory controller service", expressionLanguageScope=ExpressionLanguageScope.NONE, description="")
public class RecordSetWriterLookup
extends AbstractControllerService
implements RecordSetWriterFactory {
    public static final String RECORDWRITER_NAME_VARIABLE = "recordsetwriter.name";
    private volatile Map<String, RecordSetWriterFactory> recordSetWriterFactoryMap;

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("The RecordSetWriterFactory to return when recordwriter.name = '" + propertyDescriptorName + "'").identifiesControllerService(RecordSetWriterFactory.class).addValidator(StandardValidators.NON_BLANK_VALIDATOR).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        int numDefinedServices = 0;
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (descriptor.isDynamic()) {
                ++numDefinedServices;
            }
            String referencedId = context.getProperty(descriptor).getValue();
            if (!this.getIdentifier().equals(referencedId)) continue;
            results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).explanation("the current service cannot be registered as a RecordSetWriterFactory to lookup").valid(false).build());
        }
        if (numDefinedServices == 0) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("at least one RecordSetWriterFactory must be defined via dynamic properties").valid(false).build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HashMap<String, RecordSetWriterFactory> serviceMap = new HashMap<String, RecordSetWriterFactory>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            RecordSetWriterFactory recordSetWriterFactory = (RecordSetWriterFactory)context.getProperty(descriptor).asControllerService(RecordSetWriterFactory.class);
            serviceMap.put(descriptor.getName(), recordSetWriterFactory);
        }
        this.recordSetWriterFactoryMap = Collections.unmodifiableMap(serviceMap);
    }

    @OnDisabled
    public void onDisabled() {
        this.recordSetWriterFactoryMap = null;
    }

    public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        return this.getRecordSetWriterFactory(variables).getSchema(variables, readSchema);
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream out) {
        throw new UnsupportedOperationException("Cannot lookup RecordSetWriterFactory without variables");
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream out, Map<String, String> variables) throws SchemaNotFoundException, IOException {
        return this.getRecordSetWriterFactory(variables).createWriter(logger, schema, out, variables);
    }

    private RecordSetWriterFactory getRecordSetWriterFactory(Map<String, String> variables) {
        if (variables == null) {
            throw new UnsupportedOperationException("Cannot lookup RecordSetWriterFactory without variables");
        }
        if (!variables.containsKey(RECORDWRITER_NAME_VARIABLE)) {
            throw new ProcessException("Attributes must contain an variables name 'recordsetwriter.name'");
        }
        String recordSetWriterName = variables.get(RECORDWRITER_NAME_VARIABLE);
        if (StringUtils.isBlank((CharSequence)recordSetWriterName)) {
            throw new ProcessException("recordsetwriter.name cannot be null or blank");
        }
        RecordSetWriterFactory recordSetWriterFactory = this.recordSetWriterFactoryMap.get(recordSetWriterName);
        if (recordSetWriterFactory == null) {
            throw new ProcessException("No RecordSetWriterFactory was found for recordsetwriter.name'" + recordSetWriterName + "'");
        }
        return recordSetWriterFactory;
    }
}

