/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import avro.shaded.com.google.common.annotations.VisibleForTesting;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.serialization.RecordSchemaCacheService;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;

@CapabilityDescription(value="Provides a Schema Cache that evicts elements based on a Least-Recently-Used algorithm. This cache is not persisted, so any restart of NiFi will result in the cache being cleared. Additionally, the cache will be cleared any time that the Controller Service is stopped and restarted.")
@Tags(value={"record", "schema", "cache"})
public class VolatileSchemaCache
extends AbstractControllerService
implements RecordSchemaCacheService {
    static final PropertyDescriptor MAX_SIZE = new PropertyDescriptor.Builder().name("max-cache-size").displayName("Maximum Cache Size").description("The maximum number of Schemas to cache.").required(true).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("100").build();
    private volatile Cache<String, RecordSchema> cache;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(MAX_SIZE);
    }

    @OnEnabled
    public void setup(ConfigurationContext context) {
        int maxSize = context.getProperty(MAX_SIZE).evaluateAttributeExpressions().asInteger();
        this.cache = Caffeine.newBuilder().maximumSize((long)maxSize).build();
    }

    public String cacheSchema(RecordSchema schema) {
        String identifier = this.createIdentifier(schema);
        RecordSchema existingSchema = (RecordSchema)this.cache.get((Object)identifier, id -> schema);
        if (existingSchema == null) {
            this.getLogger().debug("Successfully cached schema with ID {} (no existing schema with this ID)", new Object[]{identifier});
            return identifier;
        }
        if (existingSchema.equals(schema)) {
            this.getLogger().debug("Successfully cached schema with ID {} (existing schema with this ID was equal)", new Object[]{identifier});
            return identifier;
        }
        String updatedIdentifier = identifier + "-" + UUID.randomUUID().toString();
        this.cache.put((Object)updatedIdentifier, (Object)schema);
        this.getLogger().debug("Schema with ID {} conflicted with new Schema. Resolved by using generated identifier {}", new Object[]{identifier, updatedIdentifier});
        return updatedIdentifier;
    }

    public Optional<RecordSchema> getSchema(String schemaIdentifier) {
        RecordSchema cachedSchema = (RecordSchema)this.cache.getIfPresent((Object)schemaIdentifier);
        return Optional.ofNullable(cachedSchema);
    }

    @VisibleForTesting
    protected String createIdentifier(RecordSchema schema) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        Optional suppliedText = schema.getSchemaText();
        if (suppliedText.isPresent()) {
            digest.update(((String)suppliedText.get()).getBytes(StandardCharsets.UTF_8));
        } else {
            this.computeHash(schema, digest);
        }
        byte[] digestBytes = digest.digest();
        return Hex.encodeHexString((byte[])digestBytes);
    }

    private void computeHash(RecordSchema schema, MessageDigest digest) {
        for (RecordField field : schema.getFields()) {
            RecordSchema childSchema;
            digest.update(field.getFieldName().getBytes(StandardCharsets.UTF_8));
            DataType dataType = field.getDataType();
            RecordFieldType fieldType = dataType.getFieldType();
            digest.update(fieldType.name().getBytes(StandardCharsets.UTF_8));
            String format = dataType.getFormat();
            if (format != null) {
                digest.update(format.getBytes(StandardCharsets.UTF_8));
            }
            if (fieldType != RecordFieldType.RECORD || (childSchema = ((RecordDataType)dataType).getChildSchema()) == null) continue;
            this.computeHash(childSchema, digest);
        }
    }
}

