/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.avro.AvroReaderWithEmbeddedSchema;
import org.apache.nifi.avro.AvroReaderWithExplicitSchema;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.EmbeddedAvroSchemaAccessStrategy;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"avro", "parse", "record", "row", "reader", "delimited", "comma", "separated", "values"})
@CapabilityDescription(value="Parses Avro data and returns each Avro record as an separate Record object. The Avro data may contain the schema itself, or the schema can be externalized and accessed by one of the methods offered by the 'Schema Access Strategy' property.")
public class AvroReader
extends SchemaRegistryService
implements RecordReaderFactory {
    private final AllowableValue EMBEDDED_AVRO_SCHEMA = new AllowableValue("embedded-avro-schema", "Use Embedded Avro Schema", "The FlowFile has the Avro Schema embedded within the content, and this schema will be used.");
    static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("cache-size").displayName("Cache Size").description("Specifies how many Schemas should be cached").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("1000").required(true).build();
    private LoadingCache<String, Schema> compiledAvroSchemaCache;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(CACHE_SIZE);
        return properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        int cacheSize = context.getProperty(CACHE_SIZE).asInteger();
        this.compiledAvroSchemaCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build(schemaText -> new Schema.Parser().parse(schemaText));
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(super.getSchemaAccessStrategyValues());
        allowableValues.add(this.EMBEDDED_AVRO_SCHEMA);
        return allowableValues;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, PropertyContext context) {
        if (this.EMBEDDED_AVRO_SCHEMA.getValue().equals(strategy)) {
            return new EmbeddedAvroSchemaAccessStrategy();
        }
        return super.getSchemaAccessStrategy(strategy, schemaRegistry, context);
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws IOException, SchemaNotFoundException {
        Schema avroSchema;
        String schemaAccessStrategy = this.getConfigurationContext().getProperty(this.getSchemaAcessStrategyDescriptor()).getValue();
        if (this.EMBEDDED_AVRO_SCHEMA.getValue().equals(schemaAccessStrategy)) {
            return new AvroReaderWithEmbeddedSchema(in);
        }
        RecordSchema recordSchema = this.getSchema(variables, in, null);
        try {
            Optional textOption;
            avroSchema = recordSchema.getSchemaFormat().isPresent() & ((String)recordSchema.getSchemaFormat().get()).equals("avro") ? ((textOption = recordSchema.getSchemaText()).isPresent() ? (Schema)this.compiledAvroSchemaCache.get(textOption.get()) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema)) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema);
        }
        catch (Exception e) {
            throw new SchemaNotFoundException("Failed to compile Avro Schema", (Throwable)e);
        }
        return new AvroReaderWithExplicitSchema(in, recordSchema, avroSchema);
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return this.EMBEDDED_AVRO_SCHEMA;
    }
}

