/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSchemaCacheService;
import org.apache.nifi.serialization.record.RecordSchema;

public class CachedSchemaAccessStrategy
implements SchemaAccessStrategy {
    private final RecordSchemaCacheService schemaCacheService;
    private final SchemaAccessStrategy backupStrategy;
    private final ComponentLog logger;

    public CachedSchemaAccessStrategy(RecordSchemaCacheService schemaCacheService, SchemaAccessStrategy backupStrategy, ComponentLog logger) {
        this.schemaCacheService = schemaCacheService;
        this.backupStrategy = backupStrategy;
        this.logger = logger;
    }

    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        String cacheIdentifier = variables.get("schema.cache.identifier");
        if (cacheIdentifier == null) {
            this.logger.debug("Cache Identifier not found. Will delegate to backup Schema Access Strategy");
            return this.backupStrategy.getSchema(variables, contentStream, readSchema);
        }
        Optional schemaOption = this.schemaCacheService.getSchema(cacheIdentifier);
        if (schemaOption.isPresent()) {
            this.logger.debug("Found Cached Record Schema with identifier {}", new Object[]{cacheIdentifier});
            return (RecordSchema)schemaOption.get();
        }
        this.logger.debug("Encountered Cache Miss with identifier {}. Will delegate to backup Schema Access Strategy", new Object[]{cacheIdentifier});
        return this.backupStrategy.getSchema(variables, contentStream, readSchema);
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return EnumSet.noneOf(SchemaField.class);
    }
}

