/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.nifi.avro.AvroRecordReader;
import org.apache.nifi.avro.NonCachingDatumReader;
import org.apache.nifi.serialization.record.RecordSchema;

public class AvroReaderWithExplicitSchema
extends AvroRecordReader {
    private final InputStream in;
    private final RecordSchema recordSchema;
    private final DatumReader<GenericRecord> datumReader;
    private BinaryDecoder decoder;
    private GenericRecord genericRecord;
    private DataFileStream<GenericRecord> dataFileStream;

    public AvroReaderWithExplicitSchema(InputStream in, RecordSchema recordSchema, Schema avroSchema) throws IOException {
        SequenceInputStream sis;
        ByteArrayInputStream bais;
        this.in = in;
        this.recordSchema = recordSchema;
        this.datumReader = new NonCachingDatumReader(avroSchema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TeeInputStream teeInputStream = new TeeInputStream(in, (OutputStream)baos);
        try {
            this.dataFileStream = new DataFileStream((InputStream)teeInputStream, new NonCachingDatumReader());
        }
        catch (IOException ioe) {
            bais = new ByteArrayInputStream(baos.toByteArray());
            sis = new SequenceInputStream(bais, in);
            this.decoder = DecoderFactory.get().binaryDecoder((InputStream)sis, null);
        }
        if (this.dataFileStream != null) {
            Schema embeddedSchema = this.dataFileStream.getSchema();
            if (!embeddedSchema.equals((Object)avroSchema)) {
                throw new IOException("Explicit schema does not match embedded schema");
            }
            bais = new ByteArrayInputStream(baos.toByteArray());
            sis = new SequenceInputStream(bais, in);
            this.dataFileStream = new DataFileStream((InputStream)sis, new NonCachingDatumReader());
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    @Override
    protected GenericRecord nextAvroRecord() throws IOException {
        if (this.dataFileStream != null) {
            return this.dataFileStream.hasNext() ? (GenericRecord)this.dataFileStream.next() : null;
        }
        if (this.decoder.isEnd()) {
            return null;
        }
        try {
            this.genericRecord = (GenericRecord)this.datumReader.read((Object)this.genericRecord, (Decoder)this.decoder);
        }
        catch (EOFException eof) {
            return null;
        }
        return this.genericRecord;
    }

    public RecordSchema getSchema() {
        return this.recordSchema;
    }
}

