/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.inference;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.schema.inference.RecordSourceFactory;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.stream.io.NonCloseableInputStream;

public class InferSchemaAccessStrategy<T>
implements SchemaAccessStrategy {
    private final RecordSourceFactory<T> recordSourceFactory;
    private final SchemaInferenceEngine<T> schemaInference;
    private final ComponentLog logger;

    public InferSchemaAccessStrategy(RecordSourceFactory<T> recordSourceFactory, SchemaInferenceEngine<T> schemaInference, ComponentLog logger) {
        this.recordSourceFactory = recordSourceFactory;
        this.schemaInference = schemaInference;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws IOException {
        contentStream.mark(10000000);
        try {
            RecordSource<T> recordSource = this.recordSourceFactory.create(variables, (InputStream)new NonCloseableInputStream(contentStream));
            RecordSchema schema = this.schemaInference.inferSchema(recordSource);
            this.logger.debug("Successfully inferred schema {}", new Object[]{schema});
            RecordSchema recordSchema = schema;
            return recordSchema;
        }
        finally {
            contentStream.reset();
        }
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return EnumSet.noneOf(SchemaField.class);
    }
}

