/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

public abstract class AvroRecordReader
implements RecordReader {
    protected abstract GenericRecord nextAvroRecord() throws IOException;

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        try {
            GenericRecord record = this.nextAvroRecord();
            if (record == null) {
                return null;
            }
            RecordSchema schema = this.getSchema();
            Map values = AvroTypeUtil.convertAvroRecordToMap((GenericRecord)record, (RecordSchema)schema);
            return new MapRecord(schema, values);
        }
        catch (IOException e) {
            throw e;
        }
        catch (MalformedRecordException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MalformedRecordException("Error while getting next record. Root cause: " + Throwables.getRootCause((Throwable)e), (Throwable)e);
        }
    }
}

