/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.grok;

import io.krakens.grok.api.GrokCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class GrokExpressionValidator
implements Validator {
    private GrokCompiler grokCompiler;
    private String patternFileName;

    public GrokExpressionValidator(String patternFileName, GrokCompiler compiler) {
        this.patternFileName = patternFileName;
        this.grokCompiler = compiler;
    }

    public GrokExpressionValidator() {
        this.grokCompiler = GrokCompiler.newInstance();
    }

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        try {
            Throwable throwable;
            InputStreamReader reader;
            try (InputStream in = this.getClass().getResourceAsStream("/default-grok-patterns.txt");){
                reader = new InputStreamReader(in);
                throwable = null;
                try {
                    this.grokCompiler.register(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
            }
            if (this.patternFileName != null) {
                in = new FileInputStream(new File(this.patternFileName));
                var5_6 = null;
                try {
                    reader = new InputStreamReader(in);
                    throwable = null;
                    try {
                        this.grokCompiler.register((Reader)reader);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((Reader)reader).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    var5_6 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (in != null) {
                        if (var5_6 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable7) {
                                var5_6.addSuppressed(throwable7);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            this.grokCompiler.compile(input);
        }
        catch (Exception e) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Invalid Grok pattern: " + e.getMessage()).build();
        }
        return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
    }
}

