/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.syslog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.syslog.events.SyslogEvent;
import org.apache.nifi.syslog.parsers.SyslogParser;
import org.apache.nifi.util.StringUtils;

public class SyslogRecordReader
implements RecordReader {
    private final BufferedReader reader;
    private RecordSchema schema;
    private final SyslogParser parser;
    private final boolean includeRaw;

    public SyslogRecordReader(SyslogParser parser, boolean includeRaw, InputStream in, RecordSchema schema) {
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.schema = schema;
        this.parser = parser;
        this.includeRaw = includeRaw;
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        if (StringUtils.isBlank((String)line)) {
            throw new MalformedRecordException("Encountered a blank message!");
        }
        SyslogEvent event = this.parser.parseEvent(ByteBuffer.wrap(line.getBytes(this.parser.getCharsetName())));
        if (!event.isValid()) {
            MalformedRecordException malformedRecordException = new MalformedRecordException(String.format("Failed to parse %s as a Syslog message: it does not conform to any of the RFC formats supported", line));
            throw malformedRecordException;
        }
        HashMap<String, String> syslogMap = new HashMap<String, String>(8);
        syslogMap.put(SyslogAttributes.PRIORITY.key(), event.getPriority());
        syslogMap.put(SyslogAttributes.SEVERITY.key(), event.getSeverity());
        syslogMap.put(SyslogAttributes.FACILITY.key(), event.getFacility());
        syslogMap.put(SyslogAttributes.VERSION.key(), event.getVersion());
        syslogMap.put(SyslogAttributes.TIMESTAMP.key(), event.getTimeStamp());
        syslogMap.put(SyslogAttributes.HOSTNAME.key(), event.getHostName());
        syslogMap.put(SyslogAttributes.BODY.key(), event.getMsgBody());
        if (this.includeRaw) {
            syslogMap.put("_raw", line);
        }
        return new MapRecord(this.schema, syslogMap);
    }

    public RecordSchema getSchema() throws MalformedRecordException {
        return this.schema;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

