/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.syslog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.syslog.events.Syslog5424Event;
import org.apache.nifi.syslog.parsers.StrictSyslog5424Parser;
import org.apache.nifi.util.StringUtils;

public class Syslog5424RecordReader
implements RecordReader {
    private final BufferedReader reader;
    private RecordSchema schema;
    private final StrictSyslog5424Parser parser;
    private final boolean includeRaw;

    public Syslog5424RecordReader(StrictSyslog5424Parser parser, boolean includeRaw, InputStream in, RecordSchema schema) {
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.schema = schema;
        this.parser = parser;
        this.includeRaw = includeRaw;
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        if (StringUtils.isBlank((String)line)) {
            throw new MalformedRecordException("Encountered a blank message!");
        }
        Syslog5424Event event = this.parser.parseEvent(ByteBuffer.wrap(line.getBytes(this.parser.getCharsetName())));
        if (!event.isValid()) {
            MalformedRecordException malformedRecordException = event.getException() != null ? new MalformedRecordException(String.format("Failed to parse %s as a Syslog message: it does not conform to any of the RFC formats supported", line), (Throwable)event.getException()) : new MalformedRecordException(String.format("Failed to parse %s as a Syslog message: it does not conform to any of the RFC formats supported", line));
            throw malformedRecordException;
        }
        HashMap<String, Object> modifiedMap = new HashMap<String, Object>(event.getFieldMap());
        modifiedMap.put(SyslogAttributes.TIMESTAMP.key(), this.convertTimeStamp((String)event.getFieldMap().get(SyslogAttributes.TIMESTAMP.key())));
        if (this.includeRaw) {
            modifiedMap.put("_raw", line);
        }
        return new MapRecord(this.schema, modifiedMap);
    }

    public RecordSchema getSchema() throws MalformedRecordException {
        return this.schema;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private Timestamp convertTimeStamp(String timeString) {
        if (timeString == null) {
            return null;
        }
        return Timestamp.from(Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse(timeString)));
    }
}

