/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.record.NullSuppression;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RawRecordWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.xml.ArrayWrapping;
import org.apache.nifi.xml.XMLRecordSetWriter;

public class WriteXMLResult
extends AbstractRecordSetWriter
implements RecordSetWriter,
RawRecordWriter {
    private static final Pattern TAG_NAME_CHARS_TO_STRIP = Pattern.compile("[/<>!&'\"]");
    private final RecordSchema recordSchema;
    private final SchemaAccessWriter schemaAccess;
    private final XMLStreamWriter writer;
    private final NullSuppression nullSuppression;
    private final boolean omitDeclaration;
    private final ArrayWrapping arrayWrapping;
    private final String arrayTagName;
    private final String recordTagName;
    private final String rootTagName;
    private final boolean allowWritingMultipleRecords;
    private boolean hasWrittenRecord;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;

    public WriteXMLResult(RecordSchema recordSchema, SchemaAccessWriter schemaAccess, OutputStream out, boolean prettyPrint, boolean omitDeclaration, NullSuppression nullSuppression, ArrayWrapping arrayWrapping, String arrayTagName, String rootTagName, String recordTagName, String charSet, String dateFormat, String timeFormat, String timestampFormat) throws IOException {
        super(out);
        this.recordSchema = recordSchema;
        this.schemaAccess = schemaAccess;
        this.nullSuppression = nullSuppression;
        this.omitDeclaration = omitDeclaration;
        this.arrayWrapping = arrayWrapping;
        this.arrayTagName = arrayTagName;
        this.rootTagName = rootTagName;
        if (recordTagName != null) {
            this.recordTagName = recordTagName;
        } else {
            Optional recordTagNameOptional;
            Optional optional = recordTagNameOptional = recordSchema.getSchemaName().isPresent() ? recordSchema.getSchemaName() : recordSchema.getIdentifier().getName();
            if (recordTagNameOptional.isPresent()) {
                this.recordTagName = (String)recordTagNameOptional.get();
            } else {
                String message = "The property '" + XMLRecordSetWriter.RECORD_TAG_NAME.getDisplayName() + "' has not been set and the writer does not find a record name in the schema.";
                throw new IOException(message);
            }
        }
        this.allowWritingMultipleRecords = this.rootTagName != null;
        this.hasWrittenRecord = false;
        SimpleDateFormat df = dateFormat == null ? null : new SimpleDateFormat(dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = prettyPrint ? new IndentingXMLStreamWriter(factory.createXMLStreamWriter(out, charSet)) : factory.createXMLStreamWriter(out, charSet);
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected void onBeginRecordSet() throws IOException {
        OutputStream out = this.getOutputStream();
        this.schemaAccess.writeHeader(this.recordSchema, out);
        try {
            if (!this.omitDeclaration) {
                this.writer.writeStartDocument();
            }
            if (this.allowWritingMultipleRecords) {
                this.writer.writeStartElement(this.rootTagName);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected Map<String, String> onFinishRecordSet() throws IOException {
        try {
            if (this.allowWritingMultipleRecords) {
                this.writer.writeEndElement();
            }
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
        return this.schemaAccess.getAttributes(this.recordSchema);
    }

    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
        super.close();
    }

    public void flush() throws IOException {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void checkWritingMultipleRecords() throws IOException {
        if (!this.allowWritingMultipleRecords && this.hasWrittenRecord) {
            String message = "The writer attempts to write multiple record although property '" + XMLRecordSetWriter.ROOT_TAG_NAME.getDisplayName() + "' has not been set. If the XMLRecordSetWriter is supposed to write multiple records into one FlowFile, this property is required to be configured.";
            throw new IOException(message);
        }
    }

    protected Map<String, String> writeRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.schemaAccess.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.checkWritingMultipleRecords();
        ArrayDeque<String> tagsToOpen = new ArrayDeque<String>();
        try {
            tagsToOpen.addLast(this.recordTagName);
            boolean closingTagRequired = this.iterateThroughRecordUsingSchema(tagsToOpen, record, this.recordSchema);
            if (closingTagRequired) {
                this.writer.writeEndElement();
                this.hasWrittenRecord = true;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
        return this.schemaAccess.getAttributes(this.recordSchema);
    }

    private boolean iterateThroughRecordUsingSchema(Deque<String> tagsToOpen, Record record, RecordSchema schema) throws XMLStreamException {
        boolean loopHasWritten = false;
        for (RecordField field : schema.getFields()) {
            DataType chosenDataType;
            String fieldName = field.getFieldName();
            DataType dataType = field.getDataType();
            Object value = record.getValue(field);
            Object coercedValue = DataTypeUtils.convertType((Object)value, (DataType)(chosenDataType = dataType.getFieldType() == RecordFieldType.CHOICE ? DataTypeUtils.chooseDataType((Object)value, (ChoiceDataType)((ChoiceDataType)dataType)) : dataType), this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            if (coercedValue != null) {
                boolean hasWritten = this.writeFieldForType(tagsToOpen, coercedValue, chosenDataType, fieldName);
                if (!hasWritten) continue;
                loopHasWritten = true;
                continue;
            }
            if (!this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) && (!this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING) || !this.recordHasField(field, record))) continue;
            this.writeAllTags(tagsToOpen, fieldName);
            this.writer.writeEndElement();
            loopHasWritten = true;
        }
        return loopHasWritten;
    }

    private boolean writeFieldForType(Deque<String> tagsToOpen, Object coercedValue, DataType dataType, String fieldName) throws XMLStreamException {
        switch (dataType.getFieldType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: {
                this.writeAllTags(tagsToOpen, fieldName);
                this.writer.writeCharacters(coercedValue.toString());
                this.writer.writeEndElement();
                return true;
            }
            case DATE: {
                this.writeAllTags(tagsToOpen, fieldName);
                String stringValue = DataTypeUtils.toString((Object)coercedValue, this.LAZY_DATE_FORMAT);
                this.writer.writeCharacters(stringValue);
                this.writer.writeEndElement();
                return true;
            }
            case TIME: {
                this.writeAllTags(tagsToOpen, fieldName);
                String stringValue = DataTypeUtils.toString((Object)coercedValue, this.LAZY_TIME_FORMAT);
                this.writer.writeCharacters(stringValue);
                this.writer.writeEndElement();
                return true;
            }
            case TIMESTAMP: {
                this.writeAllTags(tagsToOpen, fieldName);
                String stringValue = DataTypeUtils.toString((Object)coercedValue, this.LAZY_TIMESTAMP_FORMAT);
                this.writer.writeCharacters(stringValue);
                this.writer.writeEndElement();
                return true;
            }
            case RECORD: {
                Record record = (Record)coercedValue;
                RecordDataType recordDataType = (RecordDataType)dataType;
                RecordSchema childSchema = recordDataType.getChildSchema();
                tagsToOpen.addLast(fieldName);
                boolean hasWritten = this.iterateThroughRecordUsingSchema(tagsToOpen, record, childSchema);
                if (hasWritten) {
                    this.writer.writeEndElement();
                    return true;
                }
                if (this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) || this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) {
                    this.writeAllTags(tagsToOpen);
                    this.writer.writeEndElement();
                    return true;
                }
                tagsToOpen.removeLast();
                return false;
            }
            case ARRAY: {
                String wrapperName;
                String elementName;
                Object[] arrayValues = coercedValue instanceof Object[] ? (Object[])coercedValue : new Object[]{coercedValue.toString()};
                ArrayDataType arrayDataType = (ArrayDataType)dataType;
                DataType elementType = arrayDataType.getElementType();
                if (this.arrayWrapping.equals((Object)ArrayWrapping.USE_PROPERTY_FOR_ELEMENTS)) {
                    elementName = this.arrayTagName;
                    wrapperName = fieldName;
                } else if (this.arrayWrapping.equals((Object)ArrayWrapping.USE_PROPERTY_AS_WRAPPER)) {
                    elementName = fieldName;
                    wrapperName = this.arrayTagName;
                } else {
                    elementName = fieldName;
                    wrapperName = null;
                }
                if (wrapperName != null) {
                    tagsToOpen.addLast(wrapperName);
                }
                boolean loopHasWritten = false;
                for (Object element : arrayValues) {
                    DataType chosenDataType = elementType.getFieldType() == RecordFieldType.CHOICE ? DataTypeUtils.chooseDataType((Object)element, (ChoiceDataType)((ChoiceDataType)elementType)) : elementType;
                    Object coercedElement = DataTypeUtils.convertType((Object)element, (DataType)chosenDataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)elementName);
                    if (coercedElement != null) {
                        boolean hasWritten = this.writeFieldForType(tagsToOpen, coercedElement, elementType, elementName);
                        if (!hasWritten) continue;
                        loopHasWritten = true;
                        continue;
                    }
                    if (!this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) && !this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) continue;
                    this.writeAllTags(tagsToOpen, fieldName);
                    this.writer.writeEndElement();
                    loopHasWritten = true;
                }
                if (wrapperName != null) {
                    if (loopHasWritten) {
                        this.writer.writeEndElement();
                        return true;
                    }
                    if (this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) || this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) {
                        this.writeAllTags(tagsToOpen);
                        this.writer.writeEndElement();
                        return true;
                    }
                    tagsToOpen.removeLast();
                    return false;
                }
                return loopHasWritten;
            }
            case MAP: {
                MapDataType mapDataType = (MapDataType)dataType;
                DataType valueDataType = mapDataType.getValueType();
                Map map = (Map)coercedValue;
                tagsToOpen.addLast(fieldName);
                boolean loopHasWritten = false;
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    DataType chosenDataType = valueDataType.getFieldType() == RecordFieldType.CHOICE ? DataTypeUtils.chooseDataType(entry.getValue(), (ChoiceDataType)((ChoiceDataType)valueDataType)) : valueDataType;
                    Object coercedElement = DataTypeUtils.convertType(entry.getValue(), (DataType)chosenDataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)key);
                    if (coercedElement != null) {
                        boolean hasWritten = this.writeFieldForType(tagsToOpen, entry.getValue(), valueDataType, key);
                        if (!hasWritten) continue;
                        loopHasWritten = true;
                        continue;
                    }
                    if (!this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) && !this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) continue;
                    this.writeAllTags(tagsToOpen, key);
                    this.writer.writeEndElement();
                    loopHasWritten = true;
                }
                if (loopHasWritten) {
                    this.writer.writeEndElement();
                    return true;
                }
                if (this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) || this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) {
                    this.writeAllTags(tagsToOpen);
                    this.writer.writeEndElement();
                    return true;
                }
                tagsToOpen.removeLast();
                return false;
            }
        }
        return this.writeUnknownField(tagsToOpen, coercedValue, fieldName);
    }

    private void writeAllTags(Deque<String> tagsToOpen, String fieldName) throws XMLStreamException {
        tagsToOpen.addLast(fieldName);
        this.writeAllTags(tagsToOpen);
    }

    private String escapeTagName(String tagName) {
        return TAG_NAME_CHARS_TO_STRIP.matcher(tagName).replaceAll("");
    }

    private void writeAllTags(Deque<String> tagsToOpen) throws XMLStreamException {
        for (String tagName : tagsToOpen) {
            this.writer.writeStartElement(this.escapeTagName(tagName));
        }
        tagsToOpen.clear();
    }

    public WriteResult writeRawRecord(Record record) throws IOException {
        if (!this.isActiveRecordSet()) {
            this.schemaAccess.writeHeader(this.recordSchema, this.getOutputStream());
        }
        this.checkWritingMultipleRecords();
        ArrayDeque<String> tagsToOpen = new ArrayDeque<String>();
        try {
            tagsToOpen.addLast(this.recordTagName);
            boolean closingTagRequired = this.iterateThroughRecordWithoutSchema(tagsToOpen, record);
            if (closingTagRequired) {
                this.writer.writeEndElement();
                this.hasWrittenRecord = true;
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage());
        }
        Map attributes = this.schemaAccess.getAttributes(this.recordSchema);
        return WriteResult.of((int)this.incrementRecordCount(), (Map)attributes);
    }

    private boolean iterateThroughRecordWithoutSchema(Deque<String> tagsToOpen, Record record) throws XMLStreamException {
        boolean loopHasWritten = false;
        for (String fieldName : record.getRawFieldNames()) {
            Object value = record.getValue(fieldName);
            if (value != null) {
                boolean hasWritten = this.writeUnknownField(tagsToOpen, value, fieldName);
                if (!hasWritten) continue;
                loopHasWritten = true;
                continue;
            }
            if (!this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) && !this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) continue;
            this.writeAllTags(tagsToOpen, fieldName);
            this.writer.writeEndElement();
            loopHasWritten = true;
        }
        return loopHasWritten;
    }

    private boolean writeUnknownField(Deque<String> tagsToOpen, Object value, String fieldName) throws XMLStreamException {
        if (value instanceof Record) {
            Record valueAsRecord = (Record)value;
            tagsToOpen.addLast(fieldName);
            boolean hasWritten = this.iterateThroughRecordWithoutSchema(tagsToOpen, valueAsRecord);
            if (hasWritten) {
                this.writer.writeEndElement();
                return true;
            }
            if (this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) || this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) {
                this.writeAllTags(tagsToOpen);
                this.writer.writeEndElement();
                return true;
            }
            tagsToOpen.removeLast();
            return false;
        }
        if (value instanceof Object[]) {
            String wrapperName;
            String elementName;
            Object[] valueAsArray = (Object[])value;
            if (this.arrayWrapping.equals((Object)ArrayWrapping.USE_PROPERTY_FOR_ELEMENTS)) {
                elementName = this.arrayTagName;
                wrapperName = fieldName;
            } else if (this.arrayWrapping.equals((Object)ArrayWrapping.USE_PROPERTY_AS_WRAPPER)) {
                elementName = fieldName;
                wrapperName = this.arrayTagName;
            } else {
                elementName = fieldName;
                wrapperName = null;
            }
            if (wrapperName != null) {
                tagsToOpen.addLast(wrapperName);
            }
            boolean loopHasWritten = false;
            for (Object element : valueAsArray) {
                if (element != null) {
                    boolean hasWritten = this.writeUnknownField(tagsToOpen, element, elementName);
                    if (!hasWritten) continue;
                    loopHasWritten = true;
                    continue;
                }
                if (!this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) && !this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) continue;
                this.writeAllTags(tagsToOpen, fieldName);
                this.writer.writeEndElement();
                loopHasWritten = true;
            }
            if (wrapperName != null) {
                if (loopHasWritten) {
                    this.writer.writeEndElement();
                    return true;
                }
                if (this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) || this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) {
                    this.writeAllTags(tagsToOpen);
                    this.writer.writeEndElement();
                    return true;
                }
                tagsToOpen.removeLast();
                return false;
            }
            return loopHasWritten;
        }
        if (value instanceof Map) {
            Map valueAsMap = (Map)value;
            tagsToOpen.addLast(fieldName);
            boolean loopHasWritten = false;
            for (Map.Entry entry : valueAsMap.entrySet()) {
                String key = (String)entry.getKey();
                Object entryValue = entry.getValue();
                if (entryValue != null) {
                    boolean hasWritten = this.writeUnknownField(tagsToOpen, entry.getValue(), key);
                    if (!hasWritten) continue;
                    loopHasWritten = true;
                    continue;
                }
                if (!this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) && !this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) continue;
                this.writeAllTags(tagsToOpen, key);
                this.writer.writeEndElement();
                loopHasWritten = true;
            }
            if (loopHasWritten) {
                this.writer.writeEndElement();
                return true;
            }
            if (this.nullSuppression.equals((Object)NullSuppression.NEVER_SUPPRESS) || this.nullSuppression.equals((Object)NullSuppression.SUPPRESS_MISSING)) {
                this.writeAllTags(tagsToOpen);
                this.writer.writeEndElement();
                return true;
            }
            tagsToOpen.removeLast();
            return false;
        }
        this.writeAllTags(tagsToOpen, fieldName);
        this.writer.writeCharacters(value.toString());
        this.writer.writeEndElement();
        return true;
    }

    public String getMimeType() {
        return "application/xml";
    }

    private boolean recordHasField(RecordField field, Record record) {
        Set recordFieldNames = record.getRawFieldNames();
        if (recordFieldNames.contains(field.getFieldName())) {
            return true;
        }
        for (String alias : field.getAliases()) {
            if (!recordFieldNames.contains(alias)) continue;
            return true;
        }
        return false;
    }
}

