/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.nifi.csv.CSVRecordAndFieldNames;
import org.apache.nifi.csv.CSVRecordSource;
import org.apache.nifi.schema.inference.FieldTypeInference;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.SchemaInferenceUtil;

public class CSVSchemaInference
implements SchemaInferenceEngine<CSVRecordAndFieldNames> {
    private final TimeValueInference timeValueInference;

    public CSVSchemaInference(TimeValueInference timeValueInference) {
        this.timeValueInference = timeValueInference;
    }

    @Override
    public RecordSchema inferSchema(RecordSource<CSVRecordAndFieldNames> recordSource) throws IOException {
        LinkedHashMap<String, FieldTypeInference> typeMap = new LinkedHashMap<String, FieldTypeInference>();
        while (true) {
            CSVRecordAndFieldNames recordAndFieldNames;
            if ((recordAndFieldNames = recordSource.next()) == null) {
                if (!typeMap.isEmpty() || !(recordSource instanceof CSVRecordSource)) break;
                CSVRecordSource csvRecordSource = (CSVRecordSource)recordSource;
                for (String fieldName : csvRecordSource.getFieldNames()) {
                    typeMap.put(fieldName, new FieldTypeInference());
                }
                break;
            }
            this.inferSchema(recordAndFieldNames, typeMap);
        }
        return this.createSchema(typeMap);
    }

    private void inferSchema(CSVRecordAndFieldNames recordAndFieldNames, Map<String, FieldTypeInference> typeMap) {
        CSVRecord csvRecord = recordAndFieldNames.getRecord();
        for (String fieldName : recordAndFieldNames.getFieldNames()) {
            String value = csvRecord.get(fieldName);
            if (value == null) {
                return;
            }
            FieldTypeInference typeInference = typeMap.computeIfAbsent(fieldName, key -> new FieldTypeInference());
            String trimmed = this.trim(value);
            DataType dataType = SchemaInferenceUtil.getDataType(trimmed, this.timeValueInference);
            typeInference.addPossibleDataType(dataType);
        }
    }

    private String trim(String value) {
        return value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    private RecordSchema createSchema(Map<String, FieldTypeInference> inferences) {
        ArrayList recordFields = new ArrayList(inferences.size());
        inferences.forEach((fieldName, type) -> recordFields.add(new RecordField(fieldName, type.toDataType(), true)));
        return new SimpleRecordSchema(recordFields);
    }
}

