/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.nifi.json.StartingFieldStrategy;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public abstract class AbstractJsonRowRecordReader
implements RecordReader {
    private final ComponentLog logger;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;
    private boolean firstObjectConsumed = false;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper codec = new ObjectMapper();
    private JsonParser jsonParser;
    private JsonNode firstJsonNode;
    private StartingFieldStrategy strategy;

    private AbstractJsonRowRecordReader(ComponentLog logger, String dateFormat, String timeFormat, String timestampFormat) {
        this.logger = logger;
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
    }

    protected AbstractJsonRowRecordReader(InputStream in, ComponentLog logger, String dateFormat, String timeFormat, String timestampFormat) throws IOException, MalformedRecordException {
        this(logger, dateFormat, timeFormat, timestampFormat);
        try {
            this.jsonParser = jsonFactory.createParser(in);
            this.jsonParser.setCodec((ObjectCodec)codec);
            JsonToken token = this.jsonParser.nextToken();
            if (token == JsonToken.START_ARRAY) {
                token = this.jsonParser.nextToken();
            }
            this.firstJsonNode = token == JsonToken.START_OBJECT ? (JsonNode)this.jsonParser.readValueAsTree() : null;
        }
        catch (JsonParseException e) {
            throw new MalformedRecordException("Could not parse data as JSON", (Throwable)e);
        }
    }

    protected AbstractJsonRowRecordReader(InputStream in, ComponentLog logger, String dateFormat, String timeFormat, String timestampFormat, StartingFieldStrategy strategy, String nestedFieldName) throws IOException, MalformedRecordException {
        this(logger, dateFormat, timeFormat, timestampFormat);
        this.strategy = strategy;
        try {
            JsonToken token;
            this.jsonParser = jsonFactory.createParser(in);
            this.jsonParser.setCodec((ObjectCodec)codec);
            if (strategy == StartingFieldStrategy.NESTED_FIELD) {
                SerializedString serializedStartingFieldName = new SerializedString(nestedFieldName);
                while (!this.jsonParser.nextFieldName((SerializableString)serializedStartingFieldName) && this.jsonParser.hasCurrentToken()) {
                }
                logger.debug("Parsing starting at nested field [{}]", new Object[]{nestedFieldName});
            }
            if ((token = this.jsonParser.nextToken()) == JsonToken.START_ARRAY) {
                token = this.jsonParser.nextToken();
            }
            this.firstJsonNode = token == JsonToken.START_OBJECT ? (JsonNode)this.jsonParser.readValueAsTree() : null;
        }
        catch (JsonParseException e) {
            throw new MalformedRecordException("Could not parse data as JSON", (Throwable)e);
        }
    }

    protected Supplier<DateFormat> getLazyDateFormat() {
        return this.LAZY_DATE_FORMAT;
    }

    protected Supplier<DateFormat> getLazyTimeFormat() {
        return this.LAZY_TIME_FORMAT;
    }

    protected Supplier<DateFormat> getLazyTimestampFormat() {
        return this.LAZY_TIMESTAMP_FORMAT;
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        JsonNode nextNode = this.getNextJsonNode();
        if (nextNode == null) {
            return null;
        }
        RecordSchema schema = this.getSchema();
        try {
            return this.convertJsonNodeToRecord(nextNode, schema, coerceTypes, dropUnknownFields);
        }
        catch (MalformedRecordException mre) {
            throw mre;
        }
        catch (Exception e) {
            this.logger.debug("Failed to convert JSON Element {} into a Record object using schema {} due to {}", new Object[]{nextNode, schema, e.toString(), e});
            throw new MalformedRecordException("Successfully parsed a JSON object from input but failed to convert into a Record object with the given schema", (Throwable)e);
        }
    }

    protected Object getRawNodeValue(JsonNode fieldNode, String fieldName) throws IOException {
        return this.getRawNodeValue(fieldNode, null, fieldName);
    }

    protected Object getRawNodeValue(JsonNode fieldNode, DataType dataType, String fieldName) throws IOException {
        if (fieldNode == null || fieldNode.isNull()) {
            return null;
        }
        if (fieldNode.isNumber()) {
            return fieldNode.numberValue();
        }
        if (fieldNode.isBinary()) {
            return fieldNode.binaryValue();
        }
        if (fieldNode.isBoolean()) {
            return fieldNode.booleanValue();
        }
        if (fieldNode.isTextual()) {
            String textValue = fieldNode.textValue();
            if (dataType == null) {
                return textValue;
            }
            switch (dataType.getFieldType()) {
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    try {
                        return DataTypeUtils.convertType((Object)textValue, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
                    }
                    catch (Exception e) {
                        return textValue;
                    }
                }
            }
            return textValue;
        }
        if (fieldNode.isArray()) {
            DataType elementDataType;
            ArrayNode arrayNode = (ArrayNode)fieldNode;
            int numElements = arrayNode.size();
            Object[] arrayElements = new Object[numElements];
            int count = 0;
            if (dataType != null && dataType.getFieldType() == RecordFieldType.ARRAY) {
                ArrayDataType arrayDataType = (ArrayDataType)dataType;
                elementDataType = arrayDataType.getElementType();
            } else if (dataType != null && dataType.getFieldType() == RecordFieldType.CHOICE) {
                List possibleSubTypes = ((ChoiceDataType)dataType).getPossibleSubTypes();
                for (DataType possibleSubType : possibleSubTypes) {
                    if (possibleSubType.getFieldType() != RecordFieldType.ARRAY) continue;
                    ArrayDataType possibleArrayDataType = (ArrayDataType)possibleSubType;
                    DataType possibleElementType = possibleArrayDataType.getElementType();
                    Object[] possibleArrayElements = new Object[numElements];
                    int elementCounter = 0;
                    for (JsonNode node : arrayNode) {
                        Object value = this.getRawNodeValue(node, possibleElementType, fieldName);
                        possibleArrayElements[elementCounter++] = value;
                    }
                    if (!DataTypeUtils.isArrayTypeCompatible((Object)possibleArrayElements, (DataType)possibleElementType, (boolean)true)) continue;
                    return possibleArrayElements;
                }
                this.logger.debug("Couldn't find proper schema for '{}'. This could lead to some fields filtered out.", new Object[]{fieldName});
                elementDataType = dataType;
            } else {
                elementDataType = dataType;
            }
            for (JsonNode node : arrayNode) {
                Object value = this.getRawNodeValue(node, elementDataType, fieldName);
                arrayElements[count++] = value;
            }
            return arrayElements;
        }
        if (fieldNode.isObject()) {
            if (dataType != null && RecordFieldType.MAP == dataType.getFieldType()) {
                return this.getMapFromRawValue(fieldNode, dataType, fieldName);
            }
            return this.getRecordFromRawValue(fieldNode, dataType);
        }
        return null;
    }

    private Map<String, Object> getMapFromRawValue(JsonNode fieldNode, DataType dataType, String fieldName) throws IOException {
        if (dataType == null || dataType.getFieldType() != RecordFieldType.MAP) {
            return null;
        }
        MapDataType mapDataType = (MapDataType)dataType;
        DataType valueType = mapDataType.getValueType();
        HashMap<String, Object> mapValue = new HashMap<String, Object>();
        Iterator fieldItr = fieldNode.fields();
        while (fieldItr.hasNext()) {
            Map.Entry entry = (Map.Entry)fieldItr.next();
            String elementName = (String)entry.getKey();
            JsonNode elementNode = (JsonNode)entry.getValue();
            Object nodeValue = this.getRawNodeValue(elementNode, valueType, fieldName + "['" + elementName + "']");
            mapValue.put(elementName, nodeValue);
        }
        return mapValue;
    }

    private Record getRecordFromRawValue(JsonNode fieldNode, DataType dataType) throws IOException {
        SimpleRecordSchema childSchema = null;
        if (dataType != null && RecordFieldType.RECORD == dataType.getFieldType()) {
            RecordDataType recordDataType = (RecordDataType)dataType;
            childSchema = recordDataType.getChildSchema();
        } else if (dataType != null && RecordFieldType.CHOICE == dataType.getFieldType()) {
            Record record;
            ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
            List possibleSubTypes = choiceDataType.getPossibleSubTypes();
            for (DataType possibleDataType : possibleSubTypes) {
                record = this.createOptionalRecord(fieldNode, possibleDataType, true);
                if (record == null) continue;
                return record;
            }
            for (DataType possibleDataType : possibleSubTypes) {
                record = this.createOptionalRecord(fieldNode, possibleDataType, false);
                if (record == null) continue;
                return record;
            }
        }
        if (childSchema == null) {
            childSchema = new SimpleRecordSchema(Collections.emptyList());
        }
        return this.createRecordFromRawValue(fieldNode, (RecordSchema)childSchema);
    }

    private Record createOptionalRecord(JsonNode fieldNode, DataType dataType, boolean strict) throws IOException {
        if (dataType.getFieldType() == RecordFieldType.RECORD) {
            RecordSchema possibleSchema = ((RecordDataType)dataType).getChildSchema();
            Record possibleRecord = this.createRecordFromRawValue(fieldNode, possibleSchema);
            if (DataTypeUtils.isCompatibleDataType((Object)possibleRecord, (DataType)dataType, (boolean)strict)) {
                return possibleRecord;
            }
        } else if (dataType.getFieldType() == RecordFieldType.ARRAY) {
            ArrayDataType arrayDataType = (ArrayDataType)dataType;
            DataType elementType = arrayDataType.getElementType();
            return this.createOptionalRecord(fieldNode, elementType, strict);
        }
        return null;
    }

    private Record createRecordFromRawValue(JsonNode fieldNode, RecordSchema childSchema) throws IOException {
        Iterator fieldNames = fieldNode.fieldNames();
        HashMap<String, Object> childValues = new HashMap<String, Object>();
        while (fieldNames.hasNext()) {
            String childFieldName = (String)fieldNames.next();
            DataType childDataType = childSchema.getDataType(childFieldName).orElse(null);
            Object childValue = this.getRawNodeValue(fieldNode.get(childFieldName), childDataType, childFieldName);
            childValues.put(childFieldName, childValue);
        }
        return new MapRecord(childSchema, childValues);
    }

    protected JsonNode getNextJsonNode() throws IOException, MalformedRecordException {
        if (!this.firstObjectConsumed) {
            this.firstObjectConsumed = true;
            return this.firstJsonNode;
        }
        if (this.strategy == StartingFieldStrategy.NESTED_FIELD) {
            return this.getJsonNodeWithNestedNodeStrategy();
        }
        return this.getJsonNode();
    }

    private JsonNode getJsonNodeWithNestedNodeStrategy() throws IOException, MalformedRecordException {
        JsonToken token;
        block5: while (true) {
            if ((token = this.jsonParser.nextToken()) == null) {
                return null;
            }
            switch (token) {
                case START_ARRAY: {
                    continue block5;
                }
                case END_ARRAY: 
                case END_OBJECT: 
                case FIELD_NAME: {
                    return null;
                }
                case START_OBJECT: {
                    return (JsonNode)this.jsonParser.readValueAsTree();
                }
            }
            break;
        }
        throw new MalformedRecordException("Expected to get a JSON Object but got a token of type " + token.name());
    }

    private JsonNode getJsonNode() throws IOException, MalformedRecordException {
        JsonToken token;
        block4: while (true) {
            if ((token = this.jsonParser.nextToken()) == null) {
                return null;
            }
            switch (token) {
                case START_ARRAY: 
                case END_ARRAY: 
                case END_OBJECT: {
                    continue block4;
                }
                case START_OBJECT: {
                    return (JsonNode)this.jsonParser.readValueAsTree();
                }
            }
            break;
        }
        throw new MalformedRecordException("Expected to get a JSON Object but got a token of type " + token.name());
    }

    public void close() throws IOException {
        this.jsonParser.close();
    }

    protected abstract Record convertJsonNodeToRecord(JsonNode var1, RecordSchema var2, boolean var3, boolean var4) throws IOException, MalformedRecordException;
}

