/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cef;

import com.fluenda.parcefone.event.CommonEvent;
import com.fluenda.parcefone.parser.CEFParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import org.apache.nifi.schema.inference.RecordSource;

final class CEFRecordSource
implements RecordSource<CommonEvent> {
    private final CEFParser parser;
    private final BufferedReader reader;
    private final Locale locale;
    private final boolean acceptEmptyExtensions;
    private final boolean failFast;

    CEFRecordSource(InputStream in, CEFParser parser, Locale locale, boolean acceptEmptyExtensions, boolean failFast) {
        this.parser = parser;
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.locale = locale;
        this.acceptEmptyExtensions = acceptEmptyExtensions;
        this.failFast = failFast;
    }

    @Override
    public CommonEvent next() throws IOException {
        String line = this.nextLine();
        if (line == null) {
            return null;
        }
        CommonEvent event = this.parser.parse(line, true, this.acceptEmptyExtensions, this.locale);
        if (event == null && this.failFast) {
            throw new IOException("Could not parse event");
        }
        return event;
    }

    private String nextLine() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null && line.isEmpty()) {
        }
        return line;
    }
}

