/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.json.StartingFieldStrategy;
import org.apache.nifi.schema.inference.RecordSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRecordSource
implements RecordSource<JsonNode> {
    private static final Logger logger = LoggerFactory.getLogger(JsonRecordSource.class);
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final JsonParser jsonParser;
    private final StartingFieldStrategy strategy;
    private final String startingFieldName;

    public JsonRecordSource(InputStream in) throws IOException {
        this.jsonParser = jsonFactory.createParser(in);
        this.strategy = null;
        this.startingFieldName = null;
    }

    public JsonRecordSource(InputStream in, StartingFieldStrategy strategy, String startingFieldName) throws IOException {
        this.jsonParser = jsonFactory.createParser(in);
        this.strategy = strategy;
        this.startingFieldName = startingFieldName;
        if (strategy == StartingFieldStrategy.NESTED_FIELD) {
            SerializedString serializedNestedField = new SerializedString(this.startingFieldName);
            while (!this.jsonParser.nextFieldName((SerializableString)serializedNestedField) && this.jsonParser.hasCurrentToken()) {
            }
            logger.debug("Parsing starting at nested field [{}]", (Object)startingFieldName);
        }
    }

    @Override
    public JsonNode next() throws IOException {
        JsonToken token;
        do {
            if ((token = this.jsonParser.nextToken()) == null) {
                return null;
            }
            if (token != JsonToken.START_OBJECT) continue;
            return (JsonNode)this.jsonParser.readValueAsTree();
        } while (this.strategy != StartingFieldStrategy.NESTED_FIELD || token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT);
        return null;
    }

    static {
        jsonFactory.setCodec((ObjectCodec)new ObjectMapper());
    }
}

