/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.nifi.json.AbstractJsonRowRecordReader;
import org.apache.nifi.json.SchemaApplicationStrategy;
import org.apache.nifi.json.StartingFieldStrategy;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SerializedForm;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class JsonTreeRowRecordReader
extends AbstractJsonRowRecordReader {
    private final RecordSchema schema;

    public JsonTreeRowRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, String dateFormat, String timeFormat, String timestampFormat) throws IOException, MalformedRecordException {
        this(in, logger, schema, dateFormat, timeFormat, timestampFormat, null, null, null);
    }

    public JsonTreeRowRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, String dateFormat, String timeFormat, String timestampFormat, StartingFieldStrategy startingFieldStrategy, String startingFieldName, SchemaApplicationStrategy schemaApplicationStrategy) throws IOException, MalformedRecordException {
        super(in, logger, dateFormat, timeFormat, timestampFormat, startingFieldStrategy, startingFieldName);
        this.schema = startingFieldStrategy == StartingFieldStrategy.NESTED_FIELD && schemaApplicationStrategy == SchemaApplicationStrategy.WHOLE_JSON ? this.getSelectedSchema(schema, startingFieldName) : schema;
    }

    private RecordSchema getSelectedSchema(RecordSchema schema, String startingFieldName) {
        LinkedList<RecordSchema> schemas = new LinkedList<RecordSchema>();
        schemas.add(schema);
        while (!schemas.isEmpty()) {
            RecordSchema currentSchema = (RecordSchema)schemas.poll();
            Optional optionalRecordField = currentSchema.getField(startingFieldName);
            if (optionalRecordField.isPresent()) {
                return this.getChildSchemaFromField((RecordField)optionalRecordField.get());
            }
            for (RecordField field : currentSchema.getFields()) {
                if (!(field.getDataType() instanceof ArrayDataType) && !(field.getDataType() instanceof RecordDataType)) continue;
                schemas.add(this.getChildSchemaFromField(field));
            }
        }
        throw new RuntimeException(String.format("Selected schema field [%s] not found.", startingFieldName));
    }

    private RecordSchema getChildSchemaFromField(RecordField recordField) {
        if (recordField.getDataType() instanceof ArrayDataType) {
            return ((RecordDataType)((ArrayDataType)recordField.getDataType()).getElementType()).getChildSchema();
        }
        if (recordField.getDataType() instanceof RecordDataType) {
            return ((RecordDataType)recordField.getDataType()).getChildSchema();
        }
        throw new RuntimeException(String.format("Selected schema field [%s] is not record or array type.", recordField.getFieldName()));
    }

    @Override
    protected Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        return this.convertJsonNodeToRecord(jsonNode, schema, coerceTypes, dropUnknownFields, null);
    }

    private Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, boolean coerceTypes, boolean dropUnknown, String fieldNamePrefix) throws IOException, MalformedRecordException {
        if (jsonNode == null) {
            return null;
        }
        return this.convertJsonNodeToRecord(jsonNode, schema, fieldNamePrefix, coerceTypes, dropUnknown);
    }

    private JsonNode getChildNode(JsonNode jsonNode, RecordField field) {
        if (jsonNode.has(field.getFieldName())) {
            return jsonNode.get(field.getFieldName());
        }
        for (String alias : field.getAliases()) {
            if (!jsonNode.has(alias)) continue;
            return jsonNode.get(alias);
        }
        return null;
    }

    private Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, String fieldNamePrefix, boolean coerceTypes, boolean dropUnknown) throws IOException, MalformedRecordException {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>(schema.getFieldCount() * 2);
        if (dropUnknown) {
            for (RecordField recordField : schema.getFields()) {
                Object value;
                JsonNode childNode = this.getChildNode(jsonNode, recordField);
                if (childNode == null) continue;
                String fieldName = recordField.getFieldName();
                if (coerceTypes) {
                    DataType desiredType = recordField.getDataType();
                    String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                    value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                } else {
                    value = this.getRawNodeValue(childNode, recordField.getDataType(), fieldName);
                }
                values.put(fieldName, value);
            }
        } else {
            Iterator fieldNames = jsonNode.fieldNames();
            while (fieldNames.hasNext()) {
                Object value;
                String fieldName = (String)fieldNames.next();
                JsonNode childNode = jsonNode.get(fieldName);
                RecordField recordField = schema.getField(fieldName).orElse(null);
                if (coerceTypes && recordField != null) {
                    DataType desiredType = recordField.getDataType();
                    String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
                    value = this.convertField(childNode, fullFieldName, desiredType, dropUnknown);
                } else {
                    value = this.getRawNodeValue(childNode, recordField == null ? null : recordField.getDataType(), fieldName);
                }
                values.put(fieldName, value);
            }
        }
        Supplier<String> supplier = () -> ((JsonNode)jsonNode).toString();
        return new MapRecord(schema, values, SerializedForm.of(supplier, (String)"application/json"), false, dropUnknown);
    }

    protected Object convertField(JsonNode fieldNode, String fieldName, DataType desiredType, boolean dropUnknown) throws IOException, MalformedRecordException {
        if (fieldNode == null || fieldNode.isNull()) {
            return null;
        }
        switch (desiredType.getFieldType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case BIGINT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case ENUM: 
            case DATE: 
            case TIME: 
            case UUID: 
            case TIMESTAMP: {
                Object rawValue = this.getRawNodeValue(fieldNode, fieldName);
                return DataTypeUtils.convertType((Object)rawValue, (DataType)desiredType, this.getLazyDateFormat(), this.getLazyTimeFormat(), this.getLazyTimestampFormat(), (String)fieldName);
            }
            case MAP: {
                DataType valueType = ((MapDataType)desiredType).getValueType();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                Iterator fieldNameItr = fieldNode.fieldNames();
                while (fieldNameItr.hasNext()) {
                    String childName = (String)fieldNameItr.next();
                    JsonNode childNode = fieldNode.get(childName);
                    Object childValue = this.convertField(childNode, fieldName, valueType, dropUnknown);
                    map.put(childName, childValue);
                }
                return map;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)fieldNode;
                int numElements = arrayNode.size();
                Object[] arrayElements = new Object[numElements];
                int count = 0;
                for (JsonNode node : arrayNode) {
                    DataType elementType = ((ArrayDataType)desiredType).getElementType();
                    Object converted = this.convertField(node, fieldName, elementType, dropUnknown);
                    arrayElements[count++] = converted;
                }
                return arrayElements;
            }
            case RECORD: {
                if (fieldNode.isObject()) {
                    if (!(desiredType instanceof RecordDataType)) {
                        return null;
                    }
                    RecordSchema childSchema = ((RecordDataType)desiredType).getChildSchema();
                    if (childSchema == null) {
                        ArrayList<RecordField> fields = new ArrayList<RecordField>();
                        Iterator fieldNameItr = fieldNode.fieldNames();
                        while (fieldNameItr.hasNext()) {
                            fields.add(new RecordField((String)fieldNameItr.next(), RecordFieldType.STRING.getDataType()));
                        }
                        childSchema = new SimpleRecordSchema(fields);
                    }
                    return this.convertJsonNodeToRecord(fieldNode, childSchema, fieldName + ".", true, dropUnknown);
                }
                return null;
            }
            case CHOICE: {
                return DataTypeUtils.convertType((Object)this.getRawNodeValue(fieldNode, desiredType, fieldName), (DataType)desiredType, (String)fieldName);
            }
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

