/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.inference;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.xml.inference.XmlArrayNode;
import org.apache.nifi.xml.inference.XmlContainerNode;
import org.apache.nifi.xml.inference.XmlNode;
import org.apache.nifi.xml.inference.XmlNodeType;
import org.apache.nifi.xml.inference.XmlTextNode;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLEventReaderProvider;

public class XmlRecordSource
implements RecordSource<XmlNode> {
    private final XMLEventReader xmlEventReader;
    private final String contentFieldName;
    private final boolean parseXmlAttributes;

    public XmlRecordSource(InputStream in, String contentFieldName, boolean ignoreWrapper, boolean parseXmlAttributes) throws IOException {
        this.contentFieldName = contentFieldName;
        this.parseXmlAttributes = parseXmlAttributes;
        try {
            StandardXMLEventReaderProvider provider = new StandardXMLEventReaderProvider();
            this.xmlEventReader = provider.getEventReader(new StreamSource(in));
            if (ignoreWrapper) {
                this.readStartElement();
            }
        }
        catch (XMLStreamException | ProcessingException e) {
            throw new IOException("Could not parse XML", e);
        }
    }

    @Override
    public XmlNode next() throws IOException {
        try {
            StartElement startElement = this.readStartElement();
            if (startElement == null) {
                return null;
            }
            XmlNode xmlNode = this.readNext(startElement);
            return xmlNode;
        }
        catch (XMLStreamException xmle) {
            throw new IOException(xmle);
        }
    }

    private XmlNode readNext(StartElement startElement) throws XMLStreamException, IOException {
        StringBuilder content = new StringBuilder();
        LinkedHashMap<String, XmlNode> childNodes = new LinkedHashMap<String, XmlNode>();
        if (this.parseXmlAttributes) {
            this.addXmlAttributesToChildNodes(startElement, childNodes);
        }
        while (this.xmlEventReader.hasNext()) {
            Characters characters;
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isEndDocument()) {
                throw new EOFException("Expected to encounter End-of-Element tag for start tag '" + startElement.getName() + "'");
            }
            if (xmlEvent.isEndElement()) break;
            if (xmlEvent.isCharacters() && !(characters = xmlEvent.asCharacters()).isWhiteSpace()) {
                content.append(characters.getData());
            }
            if (!xmlEvent.isStartElement()) continue;
            StartElement childStartElement = xmlEvent.asStartElement();
            XmlNode childNode = this.readNext(childStartElement);
            String childName = childStartElement.getName().getLocalPart();
            XmlNode existingNode = (XmlNode)childNodes.get(childName);
            if (existingNode == null) {
                childNodes.put(childName, childNode);
                continue;
            }
            if (existingNode.getNodeType() == XmlNodeType.ARRAY) {
                ((XmlArrayNode)existingNode).addElement(childNode);
                continue;
            }
            XmlArrayNode arrayNode = new XmlArrayNode(childStartElement.getName().getLocalPart());
            arrayNode.addElement(existingNode);
            arrayNode.addElement(childNode);
            childNodes.put(childName, arrayNode);
        }
        String nodeName = startElement.getName().getLocalPart();
        if (childNodes.isEmpty()) {
            return new XmlTextNode(nodeName, content.toString().trim());
        }
        String textContent = content.toString().trim();
        if (!textContent.equals("")) {
            childNodes.put(this.contentFieldName, new XmlTextNode(this.contentFieldName, textContent));
        }
        return new XmlContainerNode(nodeName, childNodes);
    }

    private StartElement readStartElement() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!xmlEvent.isStartElement()) continue;
            StartElement startElement = xmlEvent.asStartElement();
            return startElement;
        }
        return null;
    }

    private void addXmlAttributesToChildNodes(StartElement startElement, Map<String, XmlNode> childNodes) {
        Iterator<Attribute> attributeIterator = startElement.getAttributes();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            String attributeName = attribute.getName().getLocalPart();
            childNodes.put(attributeName, new XmlTextNode(attributeName, attribute.getValue()));
        }
    }
}

