/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordFieldType;

public final class SchemaInferenceUtil {
    private SchemaInferenceUtil() {
    }

    public static DataType getDataType(String value) {
        return SchemaInferenceUtil.getDataType(value, Optional.empty());
    }

    public static DataType getDataType(String value, TimeValueInference timeValueInference) {
        return SchemaInferenceUtil.getDataType(value, Optional.of(timeValueInference));
    }

    private static DataType getDataType(String value, Optional<TimeValueInference> timeValueInference) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (NumberUtils.isParsable((String)value)) {
            if (value.contains(".")) {
                try {
                    double doubleValue = Double.parseDouble(value);
                    if (doubleValue == Double.POSITIVE_INFINITY || doubleValue == Double.NEGATIVE_INFINITY) {
                        return RecordFieldType.DECIMAL.getDecimalDataType(value.length() - 1, value.length() - 1 - value.indexOf("."));
                    }
                    if (doubleValue > 3.4028234663852886E38 || doubleValue < (double)1.4E-45f) {
                        return RecordFieldType.DOUBLE.getDataType();
                    }
                    return RecordFieldType.FLOAT.getDataType();
                }
                catch (NumberFormatException nfe) {
                    return RecordFieldType.STRING.getDataType();
                }
            }
            try {
                long longValue = Long.parseLong(value);
                if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
                    return RecordFieldType.LONG.getDataType();
                }
                return RecordFieldType.INT.getDataType();
            }
            catch (NumberFormatException nfe) {
                return RecordFieldType.STRING.getDataType();
            }
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return RecordFieldType.BOOLEAN.getDataType();
        }
        if (timeValueInference.isPresent()) {
            Optional<DataType> timeDataType = timeValueInference.get().getDataType(value);
            return timeDataType.orElse(RecordFieldType.STRING.getDataType());
        }
        return RecordFieldType.STRING.getDataType();
    }
}

