/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;

public abstract class WriteAvroResult
implements RecordSetWriter {
    private final Schema schema;

    public WriteAvroResult(Schema schema) {
        this.schema = schema;
    }

    protected Schema getSchema() {
        return this.schema;
    }

    public WriteResult write(Record record, OutputStream out) throws IOException {
        GenericRecord rec = AvroTypeUtil.createAvroRecord((Record)record, (Schema)this.schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(this.schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(this.schema, out);
            dataFileWriter.append((Object)rec);
        }
        return WriteResult.of((int)1, Collections.emptyMap());
    }

    public String getMimeType() {
        return "application/avro-binary";
    }

    public static String normalizeNameForAvro(String inputName) {
        String normalizedName = inputName.replaceAll("[^A-Za-z0-9_]", "_");
        if (Character.isDigit(normalizedName.charAt(0))) {
            normalizedName = "_" + normalizedName;
        }
        return normalizedName;
    }
}

