/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.WriteAvroResult;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class WriteAvroResultWithExternalSchema
extends WriteAvroResult {
    private final SchemaAccessWriter schemaAccessWriter;
    private final RecordSchema recordSchema;

    public WriteAvroResultWithExternalSchema(Schema avroSchema, RecordSchema recordSchema, SchemaAccessWriter schemaAccessWriter) {
        super(avroSchema);
        this.recordSchema = recordSchema;
        this.schemaAccessWriter = schemaAccessWriter;
    }

    public WriteResult write(RecordSet rs, OutputStream outStream) throws IOException {
        Record record = rs.next();
        if (record == null) {
            return WriteResult.of((int)0, Collections.emptyMap());
        }
        int nrOfRows = 0;
        Schema schema = this.getSchema();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        BufferedOutputStream bufferedOut = new BufferedOutputStream(outStream);
        this.schemaAccessWriter.writeHeader(this.recordSchema, (OutputStream)bufferedOut);
        BinaryEncoder encoder = EncoderFactory.get().blockingBinaryEncoder((OutputStream)bufferedOut, null);
        do {
            GenericRecord rec = AvroTypeUtil.createAvroRecord((Record)record, (Schema)schema);
            datumWriter.write((Object)rec, (Encoder)encoder);
            encoder.flush();
            ++nrOfRows;
        } while ((record = rs.next()) != null);
        bufferedOut.flush();
        return WriteResult.of((int)nrOfRows, (Map)this.schemaAccessWriter.getAttributes(this.recordSchema));
    }

    @Override
    public WriteResult write(Record record, OutputStream out) throws IOException {
        Schema schema = this.getSchema();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        BufferedOutputStream bufferedOut = new BufferedOutputStream(out);
        this.schemaAccessWriter.writeHeader(this.recordSchema, (OutputStream)bufferedOut);
        BinaryEncoder encoder = EncoderFactory.get().blockingBinaryEncoder((OutputStream)bufferedOut, null);
        GenericRecord rec = AvroTypeUtil.createAvroRecord((Record)record, (Schema)schema);
        datumWriter.write((Object)rec, (Encoder)encoder);
        encoder.flush();
        bufferedOut.flush();
        return WriteResult.of((int)1, (Map)this.schemaAccessWriter.getAttributes(this.recordSchema));
    }
}

