/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.WriteAvroResult;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSet;

public class WriteAvroResultWithSchema
extends WriteAvroResult {
    public WriteAvroResultWithSchema(Schema schema) {
        super(schema);
    }

    public WriteResult write(RecordSet rs, OutputStream outStream) throws IOException {
        Record record = rs.next();
        if (record == null) {
            return WriteResult.of((int)0, Collections.emptyMap());
        }
        int nrOfRows = 0;
        Schema schema = this.getSchema();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
            do {
                GenericRecord rec = AvroTypeUtil.createAvroRecord((Record)record, (Schema)schema);
                dataFileWriter.append((Object)rec);
                ++nrOfRows;
            } while ((record = rs.next()) != null);
        }
        return WriteResult.of((int)nrOfRows, Collections.emptyMap());
    }

    @Override
    public WriteResult write(Record record, OutputStream out) throws IOException {
        if (record == null) {
            return WriteResult.of((int)0, Collections.emptyMap());
        }
        Schema schema = this.getSchema();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, out);
            GenericRecord rec = AvroTypeUtil.createAvroRecord((Record)record, (Schema)schema);
            dataFileWriter.append((Object)rec);
        }
        return WriteResult.of((int)1, Collections.emptyMap());
    }
}

