/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class CSVRecordReader
implements RecordReader {
    private final CSVParser csvParser;
    private final RecordSchema schema;
    private final DateFormat dateFormat;
    private final DateFormat timeFormat;
    private final DateFormat timestampFormat;

    public CSVRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, CSVFormat csvFormat, String dateFormat, String timeFormat, String timestampFormat) throws IOException {
        this.schema = schema;
        this.dateFormat = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        this.timeFormat = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        this.timestampFormat = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(in));
        CSVFormat withHeader = csvFormat.withHeader(schema.getFieldNames().toArray(new String[0]));
        this.csvParser = new CSVParser((Reader)reader, withHeader);
    }

    public Record nextRecord() throws IOException, MalformedRecordException {
        RecordSchema schema = this.getSchema();
        Iterator iterator = this.csvParser.iterator();
        if (iterator.hasNext()) {
            CSVRecord csvRecord = (CSVRecord)iterator.next();
            HashMap<String, Object> rowValues = new HashMap<String, Object>(schema.getFieldCount());
            for (RecordField recordField : schema.getFields()) {
                String rawValue = csvRecord.get(recordField.getFieldName());
                if (rawValue == null) {
                    String alias;
                    Iterator iterator2 = recordField.getAliases().iterator();
                    while (iterator2.hasNext() && (rawValue = csvRecord.get(alias = (String)iterator2.next())) == null) {
                    }
                }
                String fieldName = recordField.getFieldName();
                if (rawValue == null) {
                    rowValues.put(fieldName, null);
                    continue;
                }
                Object converted = this.convert(rawValue, recordField.getDataType(), fieldName);
                if (converted == null) continue;
                rowValues.put(fieldName, converted);
            }
            return new MapRecord(schema, rowValues);
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    protected Object convert(String value, DataType dataType, String fieldName) {
        String trimmed;
        if (dataType == null || value == null) {
            return value;
        }
        String string = trimmed = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        if (trimmed.isEmpty()) {
            return null;
        }
        return DataTypeUtils.convertType((Object)trimmed, (DataType)dataType, (DateFormat)this.dateFormat, (DateFormat)this.timeFormat, (DateFormat)this.timestampFormat, (String)fieldName);
    }

    public void close() throws IOException {
        this.csvParser.close();
    }
}

