/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.csv.CSVUtils;

public class SingleCharacterValidator
implements Validator {
    private static final Set<String> illegalChars = new HashSet<String>();

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        String unescaped = CSVUtils.unescape(input);
        if (unescaped.length() != 1) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Value must be exactly 1 character but was " + input.length() + " in length").build();
        }
        if (illegalChars.contains(input)) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation(input + " is not a valid character for this property").build();
        }
        return new ValidationResult.Builder().input(input).subject(subject).valid(true).build();
    }

    static {
        illegalChars.add("\r");
        illegalChars.add("\n");
    }
}

