/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.stream.io.NonCloseableOutputStream;

public class WriteCSVResult
implements RecordSetWriter {
    private final CSVFormat csvFormat;
    private final RecordSchema recordSchema;
    private final SchemaAccessWriter schemaWriter;
    private final String dateFormat;
    private final String timeFormat;
    private final String timestampFormat;
    private final boolean includeHeaderLine;

    public WriteCSVResult(CSVFormat csvFormat, RecordSchema recordSchema, SchemaAccessWriter schemaWriter, String dateFormat, String timeFormat, String timestampFormat, boolean includeHeaderLine) {
        this.csvFormat = csvFormat;
        this.recordSchema = recordSchema;
        this.schemaWriter = schemaWriter;
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.timestampFormat = timestampFormat;
        this.includeHeaderLine = includeHeaderLine;
    }

    private String getFormat(RecordField field) {
        DataType dataType = field.getDataType();
        switch (dataType.getFieldType()) {
            case DATE: {
                return this.dateFormat;
            }
            case TIME: {
                return this.timeFormat;
            }
            case TIMESTAMP: {
                return this.timestampFormat;
            }
        }
        return dataType.getFormat();
    }

    public WriteResult write(RecordSet rs, OutputStream rawOut) throws IOException {
        int count = 0;
        String[] columnNames = this.recordSchema.getFieldNames().toArray(new String[0]);
        CSVFormat formatWithHeader = this.csvFormat.withHeader(columnNames).withSkipHeaderRecord(!this.includeHeaderLine);
        this.schemaWriter.writeHeader(this.recordSchema, rawOut);
        try (NonCloseableOutputStream nonCloseable = new NonCloseableOutputStream(rawOut);
             OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)nonCloseable);
             CSVPrinter printer = new CSVPrinter((Appendable)streamWriter, formatWithHeader);){
            try {
                Record record;
                while ((record = rs.next()) != null) {
                    Object[] colVals = new Object[this.recordSchema.getFieldCount()];
                    int i = 0;
                    for (RecordField recordField : this.recordSchema.getFields()) {
                        colVals[i++] = record.getAsString(recordField, this.getFormat(recordField));
                    }
                    printer.printRecord(colVals);
                    ++count;
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to serialize results", e);
            }
        }
        return WriteResult.of((int)count, (Map)this.schemaWriter.getAttributes(this.recordSchema));
    }

    public WriteResult write(Record record, OutputStream rawOut) throws IOException {
        try (NonCloseableOutputStream nonCloseable = new NonCloseableOutputStream(rawOut);
             OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)nonCloseable);
             CSVPrinter printer = new CSVPrinter((Appendable)streamWriter, this.csvFormat);){
            try {
                RecordSchema schema = record.getSchema();
                Object[] colVals = new Object[schema.getFieldCount()];
                int i = 0;
                for (RecordField recordField : schema.getFields()) {
                    colVals[i++] = record.getAsString(recordField, this.getFormat(recordField));
                }
                printer.printRecord(colVals);
            }
            catch (Exception e) {
                throw new IOException("Failed to serialize results", e);
            }
        }
        return WriteResult.of((int)1, Collections.emptyMap());
    }

    public String getMimeType() {
        return "text/csv";
    }
}

