/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractJsonRowRecordReader
implements RecordReader {
    private final ComponentLog logger;
    private final JsonParser jsonParser;
    private final boolean array;
    private final JsonNode firstJsonNode;
    private boolean firstObjectConsumed = false;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper codec = new ObjectMapper();

    public AbstractJsonRowRecordReader(InputStream in, ComponentLog logger) throws IOException, MalformedRecordException {
        this.logger = logger;
        try {
            this.jsonParser = jsonFactory.createJsonParser(in);
            this.jsonParser.setCodec((ObjectCodec)codec);
            JsonToken token = this.jsonParser.nextToken();
            if (token == JsonToken.START_ARRAY) {
                this.array = true;
                token = this.jsonParser.nextToken();
            } else {
                this.array = false;
            }
            this.firstJsonNode = token == JsonToken.START_OBJECT ? this.jsonParser.readValueAsTree() : null;
        }
        catch (JsonParseException e) {
            throw new MalformedRecordException("Could not parse data as JSON", (Throwable)e);
        }
    }

    public Record nextRecord() throws IOException, MalformedRecordException {
        if (this.firstObjectConsumed && !this.array) {
            return null;
        }
        JsonNode nextNode = this.getNextJsonNode();
        RecordSchema schema = this.getSchema();
        try {
            return this.convertJsonNodeToRecord(nextNode, schema);
        }
        catch (MalformedRecordException mre) {
            throw mre;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            this.logger.debug("Failed to convert JSON Element {} into a Record object using schema {} due to {}", new Object[]{nextNode, schema, e.toString(), e});
            throw new MalformedRecordException("Successfully parsed a JSON object from input but failed to convert into a Record object with the given schema", (Throwable)e);
        }
    }

    protected Object getRawNodeValue(JsonNode fieldNode) throws IOException {
        if (fieldNode == null || !fieldNode.isValueNode()) {
            return null;
        }
        if (fieldNode.isNumber()) {
            return fieldNode.getNumberValue();
        }
        if (fieldNode.isBinary()) {
            return fieldNode.getBinaryValue();
        }
        if (fieldNode.isBoolean()) {
            return fieldNode.getBooleanValue();
        }
        if (fieldNode.isTextual()) {
            return fieldNode.getTextValue();
        }
        return null;
    }

    private JsonNode getNextJsonNode() throws JsonParseException, IOException, MalformedRecordException {
        JsonToken token;
        if (!this.firstObjectConsumed) {
            this.firstObjectConsumed = true;
            return this.firstJsonNode;
        }
        block5: while (true) {
            if ((token = this.jsonParser.nextToken()) == null) {
                return null;
            }
            switch (token) {
                case END_OBJECT: {
                    continue block5;
                }
                case START_OBJECT: {
                    return this.jsonParser.readValueAsTree();
                }
                case END_ARRAY: 
                case START_ARRAY: {
                    return null;
                }
            }
            break;
        }
        throw new MalformedRecordException("Expected to get a JSON Object but got a token of type " + token.name());
    }

    public void close() throws IOException {
        this.jsonParser.close();
    }

    protected JsonParser getJsonParser() {
        return this.jsonParser;
    }

    protected JsonFactory getJsonFactory() {
        return jsonFactory;
    }

    protected Optional<JsonNode> getFirstJsonNode() {
        return Optional.ofNullable(this.firstJsonNode);
    }

    protected abstract Record convertJsonNodeToRecord(JsonNode var1, RecordSchema var2) throws IOException, MalformedRecordException;
}

