/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.json.JsonPathRowRecordReader;
import org.apache.nifi.json.JsonPathValidator;
import org.apache.nifi.json.JsonTreeReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"json", "jsonpath", "record", "reader", "parser"})
@CapabilityDescription(value="Parses JSON records and evaluates user-defined JSON Path's against each JSON object. The root element may be either a single JSON object or a JSON array. If a JSON array is found, each JSON object within that array is treated as a separate record. User-defined properties define the fields that should be extracted from the JSON in order to form the fields of a Record. Any JSON field that is not extracted via a JSONPath will not be returned in the JSON Records.")
@SeeAlso(value={JsonTreeReader.class})
@DynamicProperty(name="The field name for the record.", value="A JSONPath Expression that will be evaluated against each JSON record. The result of the JSONPath will be the value of the field whose name is the same as the property name.", description="User-defined properties identifiy how to extract specific fields from a JSON object in order to create a Record", supportsExpressionLanguage=false)
public class JsonPathReader
extends SchemaRegistryService
implements RecordReaderFactory {
    private volatile String dateFormat;
    private volatile String timeFormat;
    private volatile String timestampFormat;
    private volatile LinkedHashMap<String, JsonPath> jsonPaths;

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(DateTimeUtils.DATE_FORMAT);
        properties.add(DateTimeUtils.TIME_FORMAT);
        properties.add(DateTimeUtils.TIMESTAMP_FORMAT);
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("JsonPath Expression that indicates how to retrieve the value from a JSON Object for the '" + propertyDescriptorName + "' column").dynamic(true).required(false).addValidator((Validator)new JsonPathValidator()).build();
    }

    @OnEnabled
    public void compileJsonPaths(ConfigurationContext context) {
        this.dateFormat = context.getProperty(DateTimeUtils.DATE_FORMAT).getValue();
        this.timeFormat = context.getProperty(DateTimeUtils.TIME_FORMAT).getValue();
        this.timestampFormat = context.getProperty(DateTimeUtils.TIMESTAMP_FORMAT).getValue();
        LinkedHashMap<String, JsonPath> compiled = new LinkedHashMap<String, JsonPath>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            String fieldName = descriptor.getName();
            String expression = context.getProperty(descriptor).getValue();
            JsonPath jsonPath = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
            compiled.put(fieldName, jsonPath);
        }
        this.jsonPaths = compiled;
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        boolean pathSpecified = false;
        for (PropertyDescriptor property : validationContext.getProperties().keySet()) {
            if (!property.isDynamic()) continue;
            pathSpecified = true;
            break;
        }
        if (pathSpecified) {
            return Collections.emptyList();
        }
        return Collections.singleton(new ValidationResult.Builder().subject("JSON Paths").valid(false).explanation("No JSON Paths were specified").build());
    }

    public RecordReader createRecordReader(FlowFile flowFile, InputStream in, ComponentLog logger) throws IOException, MalformedRecordException, SchemaNotFoundException {
        RecordSchema schema = this.getSchema(flowFile, in);
        return new JsonPathRowRecordReader(this.jsonPaths, schema, in, logger, this.dateFormat, this.timeFormat, this.timestampFormat);
    }
}

