/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.nifi.json.AbstractJsonRowRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SerializedForm;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;

public class JsonTreeRowRecordReader
extends AbstractJsonRowRecordReader {
    private final RecordSchema schema;
    private final DateFormat dateFormat;
    private final DateFormat timeFormat;
    private final DateFormat timestampFormat;

    public JsonTreeRowRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, String dateFormat, String timeFormat, String timestampFormat) throws IOException, MalformedRecordException {
        super(in, logger);
        this.schema = schema;
        this.dateFormat = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        this.timeFormat = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        this.timestampFormat = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
    }

    @Override
    protected Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema) throws IOException, MalformedRecordException {
        return this.convertJsonNodeToRecord(jsonNode, schema, null);
    }

    private Record convertJsonNodeToRecord(JsonNode jsonNode, RecordSchema schema, String fieldNamePrefix) throws IOException, MalformedRecordException {
        if (jsonNode == null) {
            return null;
        }
        HashMap<String, Object> values = new HashMap<String, Object>(schema.getFieldCount());
        for (RecordField field : schema.getFields()) {
            String fieldName = field.getFieldName();
            JsonNode fieldNode = this.getJsonNode(jsonNode, field);
            DataType desiredType = field.getDataType();
            String fullFieldName = fieldNamePrefix == null ? fieldName : fieldNamePrefix + fieldName;
            Object value = this.convertField(fieldNode, fullFieldName, desiredType);
            values.put(fieldName, value);
        }
        Supplier<String> supplier = () -> jsonNode.toString();
        return new MapRecord(schema, values, SerializedForm.of(supplier, (String)"application/json"));
    }

    private JsonNode getJsonNode(JsonNode parent, RecordField field) {
        JsonNode fieldNode = parent.get(field.getFieldName());
        if (fieldNode != null) {
            return fieldNode;
        }
        for (String alias : field.getAliases()) {
            fieldNode = parent.get(alias);
            if (fieldNode == null) continue;
            return fieldNode;
        }
        return fieldNode;
    }

    protected Object convertField(JsonNode fieldNode, String fieldName, DataType desiredType) throws IOException, MalformedRecordException {
        if (fieldNode == null || fieldNode.isNull()) {
            return null;
        }
        switch (desiredType.getFieldType()) {
            case BOOLEAN: {
                return DataTypeUtils.toBoolean((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case BYTE: {
                return DataTypeUtils.toByte((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case CHAR: {
                return DataTypeUtils.toCharacter((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case DOUBLE: {
                return DataTypeUtils.toDouble((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case FLOAT: {
                return DataTypeUtils.toFloat((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case INT: {
                return DataTypeUtils.toInteger((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case LONG: {
                return DataTypeUtils.toLong((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case SHORT: {
                return DataTypeUtils.toShort((Object)this.getRawNodeValue(fieldNode), (String)fieldName);
            }
            case STRING: {
                return DataTypeUtils.toString((Object)this.getRawNodeValue(fieldNode), (DateFormat)DataTypeUtils.getDateFormat((RecordFieldType)desiredType.getFieldType(), (DateFormat)this.dateFormat, (DateFormat)this.timeFormat, (DateFormat)this.timestampFormat));
            }
            case DATE: {
                return DataTypeUtils.toDate((Object)this.getRawNodeValue(fieldNode), (DateFormat)this.dateFormat, (String)fieldName);
            }
            case TIME: {
                return DataTypeUtils.toTime((Object)this.getRawNodeValue(fieldNode), (DateFormat)this.timeFormat, (String)fieldName);
            }
            case TIMESTAMP: {
                return DataTypeUtils.toTimestamp((Object)this.getRawNodeValue(fieldNode), (DateFormat)this.timestampFormat, (String)fieldName);
            }
            case MAP: {
                DataType valueType = ((MapDataType)desiredType).getValueType();
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator fieldNameItr = fieldNode.getFieldNames();
                while (fieldNameItr.hasNext()) {
                    String childName = (String)fieldNameItr.next();
                    JsonNode childNode = fieldNode.get(childName);
                    Object childValue = this.convertField(childNode, fieldName + "." + childName, valueType);
                    map.put(childName, childValue);
                }
                return map;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)fieldNode;
                int numElements = arrayNode.size();
                Object[] arrayElements = new Object[numElements];
                int count = 0;
                for (JsonNode node : arrayNode) {
                    DataType elementType = ((ArrayDataType)desiredType).getElementType();
                    Object converted = this.convertField(node, fieldName, elementType);
                    arrayElements[count++] = converted;
                }
                return arrayElements;
            }
            case RECORD: {
                if (fieldNode.isObject()) {
                    if (!(desiredType instanceof RecordDataType)) {
                        return null;
                    }
                    RecordSchema childSchema = ((RecordDataType)desiredType).getChildSchema();
                    if (childSchema == null) {
                        ArrayList<RecordField> fields = new ArrayList<RecordField>();
                        Iterator fieldNameItr = fieldNode.getFieldNames();
                        while (fieldNameItr.hasNext()) {
                            fields.add(new RecordField((String)fieldNameItr.next(), RecordFieldType.STRING.getDataType()));
                        }
                        childSchema = new SimpleRecordSchema(fields);
                    }
                    return this.convertJsonNodeToRecord(fieldNode, childSchema, fieldName + ".");
                }
                return null;
            }
        }
        return null;
    }

    public RecordSchema getSchema() {
        return this.schema;
    }
}

