/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;
import org.apache.nifi.serialization.record.SerializedForm;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.stream.io.NonCloseableOutputStream;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;

public class WriteJsonResult
implements RecordSetWriter {
    private final ComponentLog logger;
    private final boolean prettyPrint;
    private final SchemaAccessWriter schemaAccess;
    private final RecordSchema recordSchema;
    private final JsonFactory factory = new JsonFactory();
    private final DateFormat dateFormat;
    private final DateFormat timeFormat;
    private final DateFormat timestampFormat;

    public WriteJsonResult(ComponentLog logger, RecordSchema recordSchema, SchemaAccessWriter schemaAccess, boolean prettyPrint, String dateFormat, String timeFormat, String timestampFormat) {
        this.logger = logger;
        this.recordSchema = recordSchema;
        this.prettyPrint = prettyPrint;
        this.schemaAccess = schemaAccess;
        this.dateFormat = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        this.timeFormat = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        this.timestampFormat = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
    }

    public WriteResult write(RecordSet rs, OutputStream rawOut) throws IOException {
        int count = 0;
        this.schemaAccess.writeHeader(this.recordSchema, rawOut);
        try (JsonGenerator generator = this.factory.createJsonGenerator((OutputStream)new NonCloseableOutputStream(rawOut));){
            Record record;
            if (this.prettyPrint) {
                generator.useDefaultPrettyPrinter();
            }
            generator.writeStartArray();
            while ((record = rs.next()) != null) {
                ++count;
                this.writeRecord(record, this.recordSchema, generator, g -> g.writeStartObject(), g -> g.writeEndObject());
            }
            generator.writeEndArray();
        }
        catch (SQLException e) {
            throw new IOException("Failed to serialize Result Set to stream", e);
        }
        return WriteResult.of((int)count, (Map)this.schemaAccess.getAttributes(this.recordSchema));
    }

    public WriteResult write(Record record, OutputStream rawOut) throws IOException {
        this.schemaAccess.writeHeader(this.recordSchema, rawOut);
        try (JsonGenerator generator = this.factory.createJsonGenerator((OutputStream)new NonCloseableOutputStream(rawOut));){
            if (this.prettyPrint) {
                generator.useDefaultPrettyPrinter();
            }
            this.writeRecord(record, this.recordSchema, generator, g -> g.writeStartObject(), g -> g.writeEndObject());
        }
        catch (SQLException e) {
            throw new IOException("Failed to write records to stream", e);
        }
        return WriteResult.of((int)1, (Map)this.schemaAccess.getAttributes(this.recordSchema));
    }

    private void writeRecord(Record record, RecordSchema writeSchema, JsonGenerator generator, GeneratorTask startTask, GeneratorTask endTask) throws JsonGenerationException, IOException, SQLException {
        Object serialized;
        SerializedForm form;
        Optional serializedForm = record.getSerializedForm();
        if (serializedForm.isPresent() && (form = (SerializedForm)serializedForm.get()).getMimeType().equals(this.getMimeType()) && record.getSchema().equals(writeSchema) && (serialized = form.getSerialized()) instanceof String) {
            generator.writeRawValue((String)serialized);
            return;
        }
        try {
            startTask.apply(generator);
            for (int i = 0; i < writeSchema.getFieldCount(); ++i) {
                RecordField field = writeSchema.getField(i);
                String fieldName = field.getFieldName();
                Object value = record.getValue(field);
                if (value == null) {
                    generator.writeNullField(fieldName);
                    continue;
                }
                generator.writeFieldName(fieldName);
                DataType dataType = (DataType)writeSchema.getDataType(fieldName).get();
                this.writeValue(generator, value, fieldName, dataType, i < writeSchema.getFieldCount() - 1);
            }
            endTask.apply(generator);
        }
        catch (Exception e) {
            this.logger.error("Failed to write {} with schema {} as a JSON Object due to {}", new Object[]{record, record.getSchema(), e.toString(), e});
            throw e;
        }
    }

    private void writeValue(JsonGenerator generator, Object value, String fieldName, DataType dataType, boolean moreCols) throws JsonGenerationException, IOException, SQLException {
        if (value == null) {
            generator.writeNull();
            return;
        }
        DataType chosenDataType = dataType.getFieldType() == RecordFieldType.CHOICE ? DataTypeUtils.chooseDataType((Object)value, (ChoiceDataType)((ChoiceDataType)dataType)) : dataType;
        Object coercedValue = DataTypeUtils.convertType((Object)value, (DataType)chosenDataType, (DateFormat)this.dateFormat, (DateFormat)this.timeFormat, (DateFormat)this.timestampFormat, (String)fieldName);
        if (coercedValue == null) {
            generator.writeNull();
            return;
        }
        switch (chosenDataType.getFieldType()) {
            case DATE: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, (DateFormat)this.dateFormat);
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case TIME: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, (DateFormat)this.timeFormat);
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case TIMESTAMP: {
                String stringValue = DataTypeUtils.toString((Object)coercedValue, (DateFormat)this.timestampFormat);
                if (DataTypeUtils.isLongTypeCompatible((Object)stringValue)) {
                    generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case DOUBLE: {
                generator.writeNumber(DataTypeUtils.toDouble((Object)coercedValue, (String)fieldName).doubleValue());
                break;
            }
            case FLOAT: {
                generator.writeNumber(DataTypeUtils.toFloat((Object)coercedValue, (String)fieldName).floatValue());
                break;
            }
            case LONG: {
                generator.writeNumber(DataTypeUtils.toLong((Object)coercedValue, (String)fieldName).longValue());
                break;
            }
            case INT: 
            case BYTE: 
            case SHORT: {
                generator.writeNumber(DataTypeUtils.toInteger((Object)coercedValue, (String)fieldName).intValue());
                break;
            }
            case CHAR: 
            case STRING: {
                generator.writeString(coercedValue.toString());
                break;
            }
            case BIGINT: {
                if (coercedValue instanceof Long) {
                    generator.writeNumber(((Long)coercedValue).longValue());
                    break;
                }
                generator.writeNumber((BigInteger)coercedValue);
                break;
            }
            case BOOLEAN: {
                String stringValue = coercedValue.toString();
                if ("true".equalsIgnoreCase(stringValue)) {
                    generator.writeBoolean(true);
                    break;
                }
                if ("false".equalsIgnoreCase(stringValue)) {
                    generator.writeBoolean(false);
                    break;
                }
                generator.writeString(stringValue);
                break;
            }
            case RECORD: {
                Record record = (Record)coercedValue;
                RecordDataType recordDataType = (RecordDataType)chosenDataType;
                RecordSchema childSchema = recordDataType.getChildSchema();
                this.writeRecord(record, childSchema, generator, gen -> gen.writeStartObject(), gen -> gen.writeEndObject());
                break;
            }
            case MAP: {
                MapDataType mapDataType = (MapDataType)chosenDataType;
                DataType valueDataType = mapDataType.getValueType();
                Map map = (Map)coercedValue;
                generator.writeStartObject();
                int i = 0;
                for (Map.Entry entry : map.entrySet()) {
                    String mapKey = (String)entry.getKey();
                    Object mapValue = entry.getValue();
                    generator.writeFieldName(mapKey);
                    this.writeValue(generator, mapValue, fieldName + "." + mapKey, valueDataType, ++i < map.size());
                }
                generator.writeEndObject();
                break;
            }
            default: {
                if (coercedValue instanceof Object[]) {
                    Object[] values = (Object[])coercedValue;
                    ArrayDataType arrayDataType = (ArrayDataType)dataType;
                    DataType elementType = arrayDataType.getElementType();
                    this.writeArray(values, fieldName, generator, elementType);
                    break;
                }
                generator.writeString(coercedValue.toString());
            }
        }
    }

    private void writeArray(Object[] values, String fieldName, JsonGenerator generator, DataType elementType) throws JsonGenerationException, IOException, SQLException {
        generator.writeStartArray();
        for (int i = 0; i < values.length; ++i) {
            boolean moreEntries = i < values.length - 1;
            Object element = values[i];
            this.writeValue(generator, element, fieldName, elementType, moreEntries);
        }
        generator.writeEndArray();
    }

    public String getMimeType() {
        return "application/json";
    }

    private static interface GeneratorTask {
        public void apply(JsonGenerator var1) throws JsonGenerationException, IOException;
    }
}

