/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.schema.access.HortonworksAttributeSchemaReferenceWriter;
import org.apache.nifi.schema.access.HortonworksEncodedSchemaReferenceWriter;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNameAsAttribute;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schema.access.SchemaTextAsAttribute;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

public abstract class SchemaRegistryRecordSetWriter
extends SchemaRegistryService {
    static final AllowableValue SCHEMA_NAME_ATTRIBUTE = new AllowableValue("schema-name", "Set 'schema.name' Attribute", "The FlowFile will be given an attribute named 'schema.name' and this attribute will indicate the name of the schema in the Schema Registry. Note that ifthe schema for a record is not obtained from a Schema Registry, then no attribute will be added.");
    static final AllowableValue AVRO_SCHEMA_ATTRIBUTE = new AllowableValue("full-schema-attribute", "Set 'avro.schema' Attribute", "The FlowFile will be given an attribute named 'avro.schema' and this attribute will contain the Avro Schema that describes the records in the FlowFile. The contents of the FlowFile need not be Avro, but the text of the schema will be used.");
    static final AllowableValue HWX_CONTENT_ENCODED_SCHEMA = new AllowableValue("hwx-content-encoded-schema", "HWX Content-Encoded Schema Reference", "The content of the FlowFile will contain a reference to a schema in the Schema Registry service. The reference is encoded as a single byte indicating the 'protocol version', followed by 8 bytes indicating the schema identifier, and finally 4 bytes indicating the schema version, as per the Hortonworks Schema Registry serializers and deserializers, as found at https://github.com/hortonworks/registry. This will be prepended to each FlowFile. Note that if the schema for a record does not contain the necessary identifier and version, an Exception will be thrown when attempting to write the data.");
    static final AllowableValue HWX_SCHEMA_REF_ATTRIBUTES = new AllowableValue("hwx-schema-ref-attributes", "HWX Schema Reference Attributes", "The FlowFile will be given a set of 3 attributes to describe the schema: 'schema.identifier', 'schema.version', and 'schema.protocol.version'. Note that if the schema for a record does not contain the necessary identifier and version, an Exception will be thrown when attempting to write the data.");
    protected static final PropertyDescriptor SCHEMA_WRITE_STRATEGY = new PropertyDescriptor.Builder().name("Schema Write Strategy").description("Specifies how the schema for a Record should be added to the data.").allowableValues(new AllowableValue[]{SCHEMA_NAME_ATTRIBUTE, AVRO_SCHEMA_ATTRIBUTE, HWX_SCHEMA_REF_ATTRIBUTES, HWX_CONTENT_ENCODED_SCHEMA}).defaultValue(SCHEMA_NAME_ATTRIBUTE.getValue()).required(true).build();
    private volatile ConfigurationContext configurationContext;
    private volatile SchemaAccessWriter schemaAccessWriter;
    private final List<AllowableValue> strategyList = Collections.unmodifiableList(Arrays.asList(SCHEMA_NAME_ATTRIBUTE, AVRO_SCHEMA_ATTRIBUTE, HWX_SCHEMA_REF_ATTRIBUTES, HWX_CONTENT_ENCODED_SCHEMA));

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        AllowableValue[] strategies = this.getSchemaWriteStrategyValues().toArray(new AllowableValue[0]);
        properties.add(new PropertyDescriptor.Builder().fromPropertyDescriptor(SCHEMA_WRITE_STRATEGY).defaultValue(this.getDefaultSchemaWriteStrategy().getValue()).allowableValues(strategies).build());
        properties.addAll(super.getSupportedPropertyDescriptors());
        return properties;
    }

    protected AllowableValue getDefaultSchemaWriteStrategy() {
        return SCHEMA_NAME_ATTRIBUTE;
    }

    protected PropertyDescriptor getSchemaWriteStrategyDescriptor() {
        return this.getPropertyDescriptor(SCHEMA_WRITE_STRATEGY.getName());
    }

    @OnEnabled
    public void storeSchemaWriteStrategy(ConfigurationContext context) {
        this.configurationContext = context;
        String writerValue = context.getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        this.schemaAccessWriter = this.getSchemaWriteStrategy(writerValue);
    }

    @Override
    protected ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    protected SchemaAccessWriter getSchemaAccessWriter(RecordSchema schema) throws SchemaNotFoundException {
        this.schemaAccessWriter.validateSchema(schema);
        return this.schemaAccessWriter;
    }

    protected List<AllowableValue> getSchemaWriteStrategyValues() {
        return this.strategyList;
    }

    protected SchemaAccessWriter getSchemaWriteStrategy(String allowableValue) {
        if (allowableValue.equalsIgnoreCase(SCHEMA_NAME_ATTRIBUTE.getValue())) {
            return new SchemaNameAsAttribute();
        }
        if (allowableValue.equalsIgnoreCase(AVRO_SCHEMA_ATTRIBUTE.getValue())) {
            return new SchemaTextAsAttribute();
        }
        if (allowableValue.equalsIgnoreCase(HWX_CONTENT_ENCODED_SCHEMA.getValue())) {
            return new HortonworksEncodedSchemaReferenceWriter();
        }
        if (allowableValue.equalsIgnoreCase(HWX_SCHEMA_REF_ATTRIBUTES.getValue())) {
            return new HortonworksAttributeSchemaReferenceWriter();
        }
        return null;
    }

    protected Set<SchemaField> getRequiredSchemaFields(ValidationContext validationContext) {
        String writeStrategyValue = validationContext.getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        SchemaAccessWriter writer = this.getSchemaWriteStrategy(writeStrategyValue);
        Set requiredFields = writer.getRequiredSchemaFields();
        return requiredFields;
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        Set<SchemaField> suppliedFields = this.getSuppliedSchemaFields(validationContext);
        Set<SchemaField> requiredFields = this.getRequiredSchemaFields(validationContext);
        HashSet<SchemaField> missingFields = new HashSet<SchemaField>(requiredFields);
        missingFields.removeAll(suppliedFields);
        if (!missingFields.isEmpty()) {
            results.add(new ValidationResult.Builder().subject("Schema Access Strategy").valid(false).explanation("The configured Schema Write Strategy requires the " + missingFields.iterator().next() + " but the configured Schema Access Strategy does not provide this information in conjunction with the selected Schema Registry. " + "This Schema Access Strategy, as configured, cannot be used in conjunction with this Schema Write Strategy.").build());
        }
        return results;
    }
}

