/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.text;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class FreeFormTextWriter
implements RecordSetWriter {
    private static final byte NEW_LINE = 10;
    private final PropertyValue propertyValue;
    private final Charset charset;

    public FreeFormTextWriter(PropertyValue textPropertyValue, Charset characterSet) {
        this.propertyValue = textPropertyValue;
        this.charset = characterSet;
    }

    public WriteResult write(RecordSet recordSet, OutputStream out) throws IOException {
        int count = 0;
        try {
            Record record;
            while ((record = recordSet.next()) != null) {
                RecordSchema schema = record.getSchema();
                List<String> colNames = this.getColumnNames(schema);
                ++count;
                this.write(record, out, colNames);
            }
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        return WriteResult.of((int)count, Collections.emptyMap());
    }

    private List<String> getColumnNames(RecordSchema schema) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (RecordField field : schema.getFields()) {
            columnNames.add(field.getFieldName());
            for (String alias : field.getAliases()) {
                columnNames.add(alias);
            }
        }
        return columnNames;
    }

    public WriteResult write(Record record, OutputStream out) throws IOException {
        this.write(record, out, this.getColumnNames(record.getSchema()));
        return WriteResult.of((int)1, Collections.emptyMap());
    }

    private void write(Record record, OutputStream out, List<String> columnNames) throws IOException {
        int numCols = columnNames.size();
        HashMap<String, String> values = new HashMap<String, String>(numCols);
        for (int i = 0; i < numCols; ++i) {
            String columnName = columnNames.get(i);
            String columnValue = record.getAsString(columnName);
            values.put(columnName, columnValue);
        }
        String evaluated = this.propertyValue.evaluateAttributeExpressions(values).getValue();
        out.write(evaluated.getBytes(this.charset));
        out.write(10);
    }

    public String getMimeType() {
        return "text/plain";
    }
}

