/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.csv;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.csv.AbstractCSVRecordReader;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

public class JacksonCSVRecordReader
extends AbstractCSVRecordReader {
    private final MappingIterator<String[]> recordStream;
    private List<String> rawFieldNames = null;
    private boolean allowDuplicateHeaderNames;
    private static volatile CsvMapper mapper = new CsvMapper().enable(CsvParser.Feature.WRAP_AS_ARRAY);

    public JacksonCSVRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, CSVFormat csvFormat, boolean hasHeader, boolean ignoreHeader, String dateFormat, String timeFormat, String timestampFormat, String encoding, boolean trimDoubleQuote) throws IOException {
        super(logger, schema, hasHeader, ignoreHeader, dateFormat, timeFormat, timestampFormat, trimDoubleQuote);
        InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(in), encoding);
        CsvSchema.Builder csvSchemaBuilder = CsvSchema.builder().setColumnSeparator(csvFormat.getDelimiter()).setLineSeparator(csvFormat.getRecordSeparator() == null ? "\n" : csvFormat.getRecordSeparator()).setAllowComments("#".equals(CharUtils.toString((Character)csvFormat.getCommentMarker()))).setUseHeader(false);
        csvSchemaBuilder = csvFormat.getQuoteCharacter() == null ? csvSchemaBuilder : csvSchemaBuilder.setQuoteChar(csvFormat.getQuoteCharacter().charValue());
        CsvSchema.Builder builder = csvSchemaBuilder = csvFormat.getEscapeCharacter() == null ? csvSchemaBuilder : csvSchemaBuilder.setEscapeChar(csvFormat.getEscapeCharacter().charValue());
        if (hasHeader && ignoreHeader) {
            csvSchemaBuilder = csvSchemaBuilder.setSkipFirstDataRow(true);
        }
        this.allowDuplicateHeaderNames = csvFormat.getAllowDuplicateHeaderNames();
        CsvSchema csvSchema = csvSchemaBuilder.build();
        ArrayList<CsvParser.Feature> features = new ArrayList<CsvParser.Feature>();
        features.add(CsvParser.Feature.INSERT_NULLS_FOR_MISSING_COLUMNS);
        if (csvFormat.getIgnoreEmptyLines()) {
            features.add(CsvParser.Feature.SKIP_EMPTY_LINES);
        }
        if (csvFormat.getTrim()) {
            features.add(CsvParser.Feature.TRIM_SPACES);
        }
        ObjectReader objReader = mapper.readerFor(String[].class).with((FormatSchema)csvSchema).withFeatures((FormatFeature[])features.toArray(new CsvParser.Feature[features.size()]));
        this.recordStream = objReader.readValues((Reader)reader);
    }

    public JacksonCSVRecordReader(InputStream in, ComponentLog logger, RecordSchema schema, CSVFormat csvFormat, boolean hasHeader, boolean ignoreHeader, String dateFormat, String timeFormat, String timestampFormat, String encoding) throws IOException {
        this(in, logger, schema, csvFormat, hasHeader, ignoreHeader, dateFormat, timeFormat, timestampFormat, encoding, true);
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        RecordSchema schema = this.getSchema();
        if (this.recordStream.hasNext()) {
            String[] csvRecord = (String[])this.recordStream.next();
            if (this.rawFieldNames == null) {
                if (!this.hasHeader || this.ignoreHeader) {
                    this.rawFieldNames = schema.getFieldNames();
                } else {
                    this.rawFieldNames = Arrays.asList(csvRecord);
                    if (this.rawFieldNames.size() > schema.getFieldCount() && !this.allowDuplicateHeaderNames) {
                        HashSet<String> deDupe = new HashSet<String>(schema.getFieldCount());
                        for (String name : this.rawFieldNames) {
                            if (deDupe.add(name)) continue;
                            throw new IllegalArgumentException(String.format("The header contains a duplicate name: \"%s\" in %s. If this is valid then use CSVFormat.withAllowDuplicateHeaderNames().", name, this.rawFieldNames));
                        }
                    }
                    if (this.recordStream.hasNext()) {
                        csvRecord = (String[])this.recordStream.next();
                    } else {
                        return null;
                    }
                }
            }
            boolean foundRecord = true;
            if (csvRecord == null || csvRecord.length == 1 && StringUtils.isEmpty((CharSequence)csvRecord[0])) {
                foundRecord = false;
                while (this.recordStream.hasNext()) {
                    csvRecord = (String[])this.recordStream.next();
                    if (csvRecord == null || csvRecord.length == 1 && StringUtils.isEmpty((CharSequence)csvRecord[0])) continue;
                    foundRecord = true;
                    break;
                }
            }
            if (!foundRecord) {
                return null;
            }
            HashMap<String, String> values = new HashMap<String, String>(this.rawFieldNames.size() * 2);
            int numFieldNames = this.rawFieldNames.size();
            for (int i = 0; i < csvRecord.length; ++i) {
                String rawFieldName = numFieldNames <= i ? "unknown_field_index_" + i : this.rawFieldNames.get(i);
                String rawValue = i >= csvRecord.length ? null : csvRecord[i];
                Optional dataTypeOption = schema.getDataType(rawFieldName);
                if (!dataTypeOption.isPresent() && dropUnknownFields) continue;
                Object value = coerceTypes && dataTypeOption.isPresent() ? this.convert(rawValue, (DataType)dataTypeOption.get(), rawFieldName) : (dataTypeOption.isPresent() ? this.convertSimpleIfPossible(rawValue, (DataType)dataTypeOption.get(), rawFieldName) : rawValue);
                values.put(rawFieldName, (String)value);
            }
            return new MapRecord(schema, values, coerceTypes, dropUnknownFields);
        }
        return null;
    }

    public void close() throws IOException {
        this.recordStream.close();
    }
}

