/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cef;

import com.fluenda.parcefone.parser.CEFParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.cef.CEFCustomExtensionTypeResolver;
import org.apache.nifi.cef.CEFRecordReader;
import org.apache.nifi.cef.CEFRecordSource;
import org.apache.nifi.cef.CEFSchemaInference;
import org.apache.nifi.cef.CEFSchemaInferenceBuilder;
import org.apache.nifi.cef.CEFSchemaUtil;
import org.apache.nifi.cef.ValidateLocale;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"cef", "record", "reader", "parser"})
@CapabilityDescription(value="Parses CEF (Common Event Format) events, returning each row as a record. This reader allows for inferring a schema based on the first event in the FlowFile or providing an explicit schema for interpreting the values.")
public final class CEFReader
extends SchemaRegistryService
implements RecordReaderFactory {
    static final AllowableValue HEADERS_ONLY = new AllowableValue("headers-only", "Headers only", "Includes only CEF header fields into the inferred schema.");
    static final AllowableValue HEADERS_AND_EXTENSIONS = new AllowableValue("headers-and-extensions", "Headers and extensions", "Includes the CEF header and extension fields to the schema, but not the custom extensions.");
    static final AllowableValue CUSTOM_EXTENSIONS_AS_STRINGS = new AllowableValue("custom-extensions-as-string", "With custom extensions as strings", "Includes all fields into the inferred schema, involving custom extension fields as string values.");
    static final AllowableValue CUSTOM_EXTENSIONS_INFERRED = new AllowableValue("custom-extensions-inferred", "With custom extensions inferred", "Includes all fields into the inferred schema, involving custom extension fields with inferred data types. The inference works based on the values in the FlowFile. In some scenarios this might result unsatisfiable behaviour. In these cases it is suggested to use \"" + CUSTOM_EXTENSIONS_AS_STRINGS.getDisplayName() + "\" Inference Strategy or predefined schema.");
    static final PropertyDescriptor INFERENCE_STRATEGY = new PropertyDescriptor.Builder().name("inference-strategy").displayName("Inference Strategy").description("Defines the set of fields should be included in the schema and the way the fields are being interpreted.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).allowableValues(new AllowableValue[]{HEADERS_ONLY, HEADERS_AND_EXTENSIONS, CUSTOM_EXTENSIONS_AS_STRINGS, CUSTOM_EXTENSIONS_INFERRED}).defaultValue(CUSTOM_EXTENSIONS_INFERRED.getValue()).dependsOn(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, new AllowableValue[]{SchemaInferenceUtil.INFER_SCHEMA}).build();
    static final PropertyDescriptor RAW_FIELD = new PropertyDescriptor.Builder().name("raw-message-field").displayName("Raw Message Field").description("If set the raw message will be added to the record using the property value as field name. This is not the same as the \"rawEvent\" extension field!").addValidator((Validator)new ValidateRawField()).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor INVALID_FIELD = new PropertyDescriptor.Builder().name("invalid-message-field").displayName("Invalid Field").description("Used when a line in the FlowFile cannot be parsed by the CEF parser. If set, instead of failing to process the FlowFile, a record is being added with one field. This record contains one field with the name specified by the property and the raw message as value.").addValidator((Validator)new ValidateRawField()).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor DATETIME_REPRESENTATION = new PropertyDescriptor.Builder().name("datetime-representation").displayName("DateTime Locale").description("The IETF BCP 47 representation of the Locale to be used when parsing date fields with long or short month names (e.g. may <en-US> vs. mai. <fr-FR>. The defaultvalue is generally safe. Only change if having issues parsing CEF messages").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator((Validator)new ValidateLocale()).defaultValue("en-US").build();
    static final PropertyDescriptor ACCEPT_EMPTY_EXTENSIONS = new PropertyDescriptor.Builder().name("accept-empty-extensions").displayName("Accept empty extensions").description("If set to true, empty extensions will be accepted and will be associated to a null value.").addValidator(StandardValidators.BOOLEAN_VALIDATOR).required(true).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    private final javax.validation.Validator validator = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();
    private final CEFParser parser = new CEFParser(this.validator);
    private volatile String rawMessageField;
    private volatile String invalidField;
    private volatile Locale parcefoneLocale;
    private volatile boolean includeCustomExtensions;
    private volatile boolean acceptEmptyExtensions;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(RAW_FIELD);
        properties.add(INVALID_FIELD);
        properties.add(DATETIME_REPRESENTATION);
        properties.add(INFERENCE_STRATEGY);
        properties.add(new PropertyDescriptor.Builder().fromPropertyDescriptor(SchemaInferenceUtil.SCHEMA_CACHE).dependsOn(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, new AllowableValue[]{SchemaInferenceUtil.INFER_SCHEMA}).build());
        properties.add(ACCEPT_EMPTY_EXTENSIONS);
        return properties;
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>(super.getSchemaAccessStrategyValues());
        allowableValues.add(SchemaInferenceUtil.INFER_SCHEMA);
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return SchemaInferenceUtil.INFER_SCHEMA;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, PropertyContext context) {
        if (strategy.equals(SchemaInferenceUtil.INFER_SCHEMA.getValue())) {
            String inferenceStrategy = context.getProperty(INFERENCE_STRATEGY).getValue();
            CEFSchemaInferenceBuilder builder = new CEFSchemaInferenceBuilder();
            if (inferenceStrategy.equals(HEADERS_AND_EXTENSIONS.getValue())) {
                builder.withExtensions();
            } else if (inferenceStrategy.equals(CUSTOM_EXTENSIONS_AS_STRINGS.getValue())) {
                builder.withCustomExtensions(CEFCustomExtensionTypeResolver.STRING_RESOLVER);
            } else if (inferenceStrategy.equals(CUSTOM_EXTENSIONS_INFERRED.getValue())) {
                builder.withCustomExtensions(CEFCustomExtensionTypeResolver.SIMPLE_RESOLVER);
            }
            if (this.rawMessageField != null) {
                builder.withRawMessage(this.rawMessageField);
            }
            if (this.invalidField != null) {
                builder.withInvalidField(this.invalidField);
            }
            boolean failFast = this.invalidField == null || this.invalidField.isEmpty();
            CEFSchemaInference inference = builder.build();
            return SchemaInferenceUtil.getSchemaAccessStrategy(strategy, context, this.getLogger(), (variables, in) -> new CEFRecordSource(in, this.parser, this.parcefoneLocale, this.acceptEmptyExtensions, failFast), () -> inference, () -> super.getSchemaAccessStrategy(strategy, schemaRegistry, context));
        }
        return super.getSchemaAccessStrategy(strategy, schemaRegistry, context);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.rawMessageField = context.getProperty(RAW_FIELD).evaluateAttributeExpressions().getValue();
        this.invalidField = context.getProperty(INVALID_FIELD).evaluateAttributeExpressions().getValue();
        this.parcefoneLocale = Locale.forLanguageTag(context.getProperty(DATETIME_REPRESENTATION).evaluateAttributeExpressions().getValue());
        String inferenceStrategy = context.getProperty(INFERENCE_STRATEGY).getValue();
        boolean inferenceNeedsCustomExtensions = !inferenceStrategy.equals(HEADERS_ONLY.getValue()) && !inferenceStrategy.equals(HEADERS_AND_EXTENSIONS.getValue());
        boolean isInferSchema = context.getProperty(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY).getValue().equals(SchemaInferenceUtil.INFER_SCHEMA.getValue());
        this.includeCustomExtensions = !isInferSchema || inferenceNeedsCustomExtensions;
        this.acceptEmptyExtensions = context.getProperty(ACCEPT_EMPTY_EXTENSIONS).asBoolean();
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws MalformedRecordException, IOException, SchemaNotFoundException {
        RecordSchema schema = this.getSchema(variables, in, null);
        return new CEFRecordReader(in, schema, this.parser, logger, this.parcefoneLocale, this.rawMessageField, this.invalidField, this.includeCustomExtensions, this.acceptEmptyExtensions);
    }

    private static class ValidateRawField
    implements Validator {
        private final Set<String> headerFields = CEFSchemaUtil.getHeaderFields().stream().map(r -> r.getFieldName()).collect(Collectors.toSet());
        private final Set<String> extensionFields = CEFSchemaUtil.getExtensionTypeMapping().keySet().stream().flatMap(fields -> fields.stream()).collect(Collectors.toSet());

        private ValidateRawField() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (this.headerFields.contains(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(input + " is one of the CEF header fields.").build();
            }
            if (this.extensionFields.contains(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(input + " is one of the CEF extension fields.").build();
            }
            return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
        }
    }
}

