/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;

public class EmbeddedAvroSchemaAccessStrategy
implements SchemaAccessStrategy {
    private final Set<SchemaField> schemaFields = EnumSet.of(SchemaField.SCHEMA_TEXT, SchemaField.SCHEMA_TEXT_FORMAT);

    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        DataFileStream dataFileStream = new DataFileStream(contentStream, (DatumReader)new GenericDatumReader());
        Schema avroSchema = dataFileStream.getSchema();
        RecordSchema recordSchema = AvroTypeUtil.createSchema((Schema)avroSchema);
        return recordSchema;
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return this.schemaFields;
    }
}

