/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;

public class NonCachingDatumReader<T>
extends GenericDatumReader<T> {
    public NonCachingDatumReader() {
    }

    public NonCachingDatumReader(Schema schema) {
        super(schema);
    }

    protected Object readString(Object old, Schema expected, Decoder in) throws IOException {
        Class stringClass = this.findStringClass(expected);
        if (stringClass == String.class) {
            return in.readString();
        }
        if (stringClass == CharSequence.class) {
            return this.readString(old, in);
        }
        return this.newInstanceFromString(stringClass, in.readString());
    }

    protected Class findStringClass(Schema schema) {
        String name = schema.getProp("avro.java.string");
        if ("String".equals(name)) {
            return String.class;
        }
        return CharSequence.class;
    }
}

