/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.syslog;

import com.github.palindromicity.syslog.KeyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.serialization.record.StandardSchemaIdentifier;
import org.apache.nifi.syslog.Syslog5424RecordReader;
import org.apache.nifi.syslog.attributes.Syslog5424Attributes;
import org.apache.nifi.syslog.attributes.SyslogAttributes;
import org.apache.nifi.syslog.keyproviders.SimpleKeyProvider;
import org.apache.nifi.syslog.parsers.StrictSyslog5424Parser;
import org.apache.nifi.syslog.utils.NifiStructuredDataPolicy;
import org.apache.nifi.syslog.utils.NilHandlingPolicy;

@Tags(value={"syslog 5424", "syslog", "logs", "logfiles", "parse", "text", "record", "reader"})
@CapabilityDescription(value="Provides a mechanism for reading RFC 5424 compliant Syslog data, such as log files, and structuring the data so that it can be processed.")
public class Syslog5424Reader
extends SchemaRegistryService
implements RecordReaderFactory {
    public static final String RFC_5424_SCHEMA_NAME = "default-5424-schema";
    static final AllowableValue RFC_5424_SCHEMA = new AllowableValue("default-5424-schema", "Use RFC 5424 Schema", "The schema will be the default schema per RFC 5424.");
    static final String RAW_MESSAGE_NAME = "_raw";
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("Character Set").description("Specifies which character set of the Syslog messages").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
    public static final PropertyDescriptor ADD_RAW = new PropertyDescriptor.Builder().displayName("Raw message").name("syslog-5424-reader-raw-message").description("If true, the record will have a _raw field containing the raw message").required(true).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    private volatile StrictSyslog5424Parser parser;
    private static volatile boolean includeRaw;
    private volatile RecordSchema recordSchema;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(2);
        properties.add(CHARSET);
        properties.add(ADD_RAW);
        return properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String charsetName = context.getProperty(CHARSET).getValue();
        includeRaw = context.getProperty(ADD_RAW).asBoolean();
        this.parser = new StrictSyslog5424Parser(Charset.forName(charsetName), NilHandlingPolicy.NULL, NifiStructuredDataPolicy.MAP_OF_MAPS, (KeyProvider)new SimpleKeyProvider());
        this.recordSchema = Syslog5424Reader.createRecordSchema();
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(RFC_5424_SCHEMA);
        return allowableValues;
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return RFC_5424_SCHEMA;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, PropertyContext context) {
        return this.createAccessStrategy();
    }

    static RecordSchema createRecordSchema() {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        fields.add(new RecordField(SyslogAttributes.PRIORITY.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.SEVERITY.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.FACILITY.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.VERSION.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.TIMESTAMP.key(), RecordFieldType.TIMESTAMP.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.HOSTNAME.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(SyslogAttributes.BODY.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(Syslog5424Attributes.APP_NAME.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(Syslog5424Attributes.PROCID.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(Syslog5424Attributes.MESSAGEID.key(), RecordFieldType.STRING.getDataType(), true));
        fields.add(new RecordField(Syslog5424Attributes.STRUCTURED_BASE.key(), RecordFieldType.MAP.getMapDataType(RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()))));
        if (includeRaw) {
            fields.add(new RecordField(RAW_MESSAGE_NAME, RecordFieldType.STRING.getDataType(), true));
        }
        SchemaIdentifier schemaIdentifier = new StandardSchemaIdentifier.Builder().name(RFC_5424_SCHEMA_NAME).build();
        SimpleRecordSchema schema = new SimpleRecordSchema(fields, schemaIdentifier);
        return schema;
    }

    private SchemaAccessStrategy createAccessStrategy() {
        return new SchemaAccessStrategy(){
            private final Set<SchemaField> schemaFields = EnumSet.noneOf(SchemaField.class);

            public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) {
                return Syslog5424Reader.this.recordSchema;
            }

            public Set<SchemaField> getSuppliedSchemaFields() {
                return this.schemaFields;
            }
        };
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws IOException, SchemaNotFoundException {
        RecordSchema schema = this.getSchema(variables, in, null);
        return new Syslog5424RecordReader(this.parser, includeRaw, in, schema);
    }
}

