/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cef;

import java.util.Locale;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class ValidateLocale
implements Validator {
    public ValidationResult validate(String subject, String input, ValidationContext context) {
        if (null == input || input.isEmpty()) {
            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(subject + " cannot be empty").build();
        }
        Locale testLocale = Locale.forLanguageTag(input);
        Locale[] availableLocales = Locale.getAvailableLocales();
        if (availableLocales[0].equals(testLocale)) {
            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(input + " is not a valid locale format.").build();
        }
        return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
    }
}

