/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.lookup;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.lookup.RecordSetWriterLookup;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;

@Tags(value={"lookup", "parse", "record", "row", "reader"})
@SeeAlso(value={RecordSetWriterLookup.class})
@CapabilityDescription(value="Provides a RecordReaderFactory that can be used to dynamically select another RecordReaderFactory. This will allow multiple RecordReaderFactories to be defined and registered, and then selected dynamically at runtime by referencing a FlowFile attribute in the Service to Use property.")
@DynamicProperty(name="Name of the RecordReader", value="A RecordReaderFactory controller service", description="", expressionLanguageScope=ExpressionLanguageScope.NONE)
public class ReaderLookup
extends AbstractControllerService
implements RecordReaderFactory {
    static final PropertyDescriptor SERVICE_TO_USE = new PropertyDescriptor.Builder().name("Service to Use").displayName("Service to Use").description("Specifies the name of the user-defined property whose associated Controller Service should be used.").required(true).defaultValue("${recordreader.name}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private volatile Map<String, RecordReaderFactory> recordReaderFactoryMap;
    private volatile PropertyValue serviceToUseValue;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.singletonList(SERVICE_TO_USE);
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).description("The RecordReaderFactory to return when '" + propertyDescriptorName + "' is the chosen Record Reader").identifiesControllerService(RecordReaderFactory.class).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        String selectedValue;
        PropertyValue serviceToUseValue;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        HashSet<String> serviceNames = new HashSet<String>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (descriptor.isDynamic()) {
                serviceNames.add(descriptor.getName());
            }
            String referencedId = context.getProperty(descriptor).getValue();
            if (!this.getIdentifier().equals(referencedId)) continue;
            results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).explanation("The current service cannot be registered as a RecordReaderFactory to lookup").valid(false).build());
        }
        if (serviceNames.isEmpty()) {
            results.add(new ValidationResult.Builder().subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("At least one RecordReaderFactory must be defined via dynamic properties").valid(false).build());
        }
        if (!(serviceToUseValue = context.getProperty(SERVICE_TO_USE)).isExpressionLanguagePresent() && !serviceNames.contains(selectedValue = serviceToUseValue.getValue())) {
            results.add(new ValidationResult.Builder().subject(SERVICE_TO_USE.getDisplayName()).explanation("No service is defined with the name <" + selectedValue + ">").valid(false).build());
        }
        return results;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        HashMap<String, RecordReaderFactory> serviceMap = new HashMap<String, RecordReaderFactory>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            RecordReaderFactory recordReaderFactory = (RecordReaderFactory)context.getProperty(descriptor).asControllerService(RecordReaderFactory.class);
            serviceMap.put(descriptor.getName(), recordReaderFactory);
        }
        this.recordReaderFactoryMap = Collections.unmodifiableMap(serviceMap);
        this.serviceToUseValue = context.getProperty(SERVICE_TO_USE);
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws MalformedRecordException, IOException, SchemaNotFoundException {
        String serviceName = this.serviceToUseValue.evaluateAttributeExpressions(variables).getValue();
        if (serviceName.trim().isEmpty()) {
            throw new ProcessException("Unable to determine which Record Reader to use: after evaluating the property value against supplied variables, got an empty value");
        }
        RecordReaderFactory recordReaderFactory = this.recordReaderFactoryMap.get(serviceName);
        if (recordReaderFactory == null) {
            throw new ProcessException("No RecordReaderFactory was configured with the name <" + serviceName + ">");
        }
        return recordReaderFactory.createRecordReader(variables, in, inputLength, logger);
    }
}

