/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.windowsevent;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.stream.io.NonCloseableInputStream;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.xml.inference.XmlSchemaInference;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLEventReaderProvider;

public class WindowsEventLogRecordReader
implements RecordReader {
    private final ComponentLog logger;
    private final RecordSchema schema;
    private boolean isArray = false;
    private XMLEventReader xmlEventReader;
    private StartElement currentRecordStartTag;
    private final XmlSchemaInference xmlSchemaInference;
    private final Supplier<DateFormat> LAZY_DATE_FORMAT;
    private final Supplier<DateFormat> LAZY_TIME_FORMAT;
    private final Supplier<DateFormat> LAZY_TIMESTAMP_FORMAT;
    private static final String DATA_TAG = "Data";
    private static final String BINARY_TAG = "Binary";
    private static final SimpleRecordSchema SYSTEM_SCHEMA;
    private static final RecordField PROVIDER_GUID_FIELD;
    private static final RecordField PROVIDER_NAME_FIELD;
    private static final RecordField TIME_CREATED_SYSTEMTIME_FIELD;
    private static final RecordField EXECUTION_THREADID_FIELD;
    private static final RecordField EXECUTION_PROCESSID_FIELD;
    private static final RecordField EVENT_ID_FIELD;
    private static final RecordField VERSION_FIELD;
    private static final RecordField LEVEL_FIELD;
    private static final RecordField TASK_FIELD;
    private static final RecordField OPCODE_FIELD;
    private static final RecordField KEYWORDS_FIELD;
    private static final RecordField EVENTRECORDID_FIELD;
    private static final RecordField CORRELATION_FIELD;
    private static final RecordField CHANNEL_FIELD;
    private static final RecordField COMPUTER_FIELD;
    private static final RecordField SECURITY_FIELD;

    public WindowsEventLogRecordReader(InputStream in, String dateFormat, String timeFormat, String timestampFormat, ComponentLog logger) throws IOException, MalformedRecordException {
        NonCloseableInputStream inputStream;
        this.logger = logger;
        DateFormat df = dateFormat == null ? null : DataTypeUtils.getDateFormat((String)dateFormat);
        DateFormat tf = timeFormat == null ? null : DataTypeUtils.getDateFormat((String)timeFormat);
        DateFormat tsf = timestampFormat == null ? null : DataTypeUtils.getDateFormat((String)timestampFormat);
        this.LAZY_DATE_FORMAT = () -> df;
        this.LAZY_TIME_FORMAT = () -> tf;
        this.LAZY_TIMESTAMP_FORMAT = () -> tsf;
        StandardXMLEventReaderProvider provider = new StandardXMLEventReaderProvider();
        try {
            inputStream = new NonCloseableInputStream(in);
            inputStream.mark(Integer.MAX_VALUE);
            this.xmlEventReader = provider.getEventReader(new StreamSource((InputStream)inputStream));
            this.xmlSchemaInference = new XmlSchemaInference(new TimeValueInference(dateFormat, timeFormat, timestampFormat));
        }
        catch (ProcessingException e) {
            throw new MalformedRecordException("Error creating XML Event reader from FlowFile input stream", (Throwable)e);
        }
        try {
            this.schema = this.determineSchema();
        }
        catch (XMLStreamException e) {
            throw new MalformedRecordException("Error reading records to determine the FlowFile's RecordSchema", (Throwable)e);
        }
        try {
            inputStream.reset();
            this.xmlEventReader = provider.getEventReader(new StreamSource((InputStream)inputStream));
            if (this.isArray) {
                this.skipToNextStartTag();
            }
            this.setNextRecordStartTag();
        }
        catch (XMLStreamException e) {
            throw new MalformedRecordException("Error resetting the XML input stream to the first Windows Log Event, current XML tag = " + this.currentRecordStartTag, (Throwable)e);
        }
    }

    public Record nextRecord(boolean coerceTypes, boolean dropUnknownFields) throws IOException, MalformedRecordException {
        if (this.currentRecordStartTag == null) {
            return null;
        }
        try {
            Record record = this.parseRecord(this.currentRecordStartTag, this.schema, coerceTypes, dropUnknownFields);
            this.setNextRecordStartTag();
            if (record != null) {
                return record;
            }
            return new MapRecord(this.schema, Collections.emptyMap());
        }
        catch (XMLStreamException e) {
            throw new MalformedRecordException("Could not parse XML", (Throwable)e);
        }
    }

    public RecordSchema getSchema() throws MalformedRecordException {
        return this.schema;
    }

    public void close() throws IOException {
        try {
            this.xmlEventReader.close();
        }
        catch (XMLStreamException e) {
            this.logger.error("Unable to close XMLEventReader");
        }
    }

    private RecordSchema determineSchema() throws XMLStreamException {
        this.setNextRecordStartTag();
        if (this.currentRecordStartTag == null) {
            throw new XMLStreamException("No root tag found, must be one of <Events> or <Event>");
        }
        if (this.currentRecordStartTag.getName().getLocalPart().equals("Events")) {
            this.isArray = true;
            this.setNextRecordStartTag();
        }
        if (this.currentRecordStartTag == null) {
            return this.generateFullSchema((RecordSchema)new SimpleRecordSchema(Collections.emptyList()));
        }
        ArrayList<RecordField> dataFields = new ArrayList<RecordField>();
        ArrayList<String> dataFieldNames = new ArrayList<String>();
        while (this.currentRecordStartTag != null) {
            if (!this.currentRecordStartTag.getName().getLocalPart().equals("Event")) {
                throw new XMLStreamException("Expecting <Event> tag but found unknown/invalid tag " + this.currentRecordStartTag.getName().getLocalPart());
            }
            this.setNextRecordStartTag();
            while (this.currentRecordStartTag != null && !this.currentRecordStartTag.getName().getLocalPart().equals("EventData")) {
                this.skipElement();
                this.setNextRecordStartTag();
            }
            if (this.currentRecordStartTag == null) {
                throw new XMLStreamException("Expecting <EventData> tag but found none");
            }
            this.setNextRecordStartTag();
            if (this.currentRecordStartTag == null) continue;
            String eventDataElementName = this.currentRecordStartTag.getName().getLocalPart();
            dataFields.addAll(this.getDataFieldsFrom(eventDataElementName, dataFieldNames));
        }
        return this.generateFullSchema((RecordSchema)new SimpleRecordSchema(dataFields));
    }

    private List<RecordField> getDataFieldsFrom(String eventDataElementName, List<String> dataFieldNames) throws XMLStreamException {
        ArrayList<RecordField> dataFields = new ArrayList<RecordField>();
        while (DATA_TAG.equals(eventDataElementName)) {
            String dataFieldName;
            StartElement dataElement = this.currentRecordStartTag;
            String content = this.getContent();
            Iterator<Attribute> iterator = dataElement.getAttributes();
            if (!iterator.hasNext()) {
                dataFieldName = content;
                this.setNextRecordStartTag();
                eventDataElementName = this.currentRecordStartTag.getName().getLocalPart();
                if (!BINARY_TAG.equals(eventDataElementName)) {
                    throw new XMLStreamException("Expecting <Binary> tag containing data for element: " + dataFieldName);
                }
                content = this.getContent();
            } else {
                Attribute attribute = iterator.next();
                String attributeName = attribute.getName().getLocalPart();
                if (!"Name".equals(attributeName)) {
                    throw new XMLStreamException("Expecting 'Name' attribute, actual: " + attributeName);
                }
                dataFieldName = attribute.getValue();
            }
            if (!dataFieldNames.contains(dataFieldName)) {
                DataType dataElementDataType = this.xmlSchemaInference.inferTextualDataType(content);
                RecordField newRecordField = new RecordField(dataFieldName, dataElementDataType, true);
                dataFields.add(newRecordField);
                dataFieldNames.add(dataFieldName);
            }
            this.setNextRecordStartTag();
            eventDataElementName = this.currentRecordStartTag == null ? null : this.currentRecordStartTag.getName().getLocalPart();
        }
        return dataFields;
    }

    private void skipElement() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                this.skipElement();
            }
            if (!xmlEvent.isEndElement()) continue;
            return;
        }
    }

    private void skipToNextStartTag() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!xmlEvent.isStartElement()) continue;
            return;
        }
    }

    private void setNextRecordStartTag() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!xmlEvent.isStartElement()) continue;
            this.currentRecordStartTag = xmlEvent.asStartElement();
            return;
        }
        this.currentRecordStartTag = null;
    }

    private RecordSchema generateFullSchema(RecordSchema dataElementsSchema) {
        ArrayList<RecordField> fullSchemaFields = new ArrayList<RecordField>(2);
        fullSchemaFields.add(new RecordField("System", RecordFieldType.RECORD.getRecordDataType((RecordSchema)SYSTEM_SCHEMA)));
        fullSchemaFields.add(new RecordField("EventData", RecordFieldType.RECORD.getRecordDataType(dataElementsSchema)));
        SimpleRecordSchema fullSchema = new SimpleRecordSchema(fullSchemaFields);
        fullSchema.setSchemaName("Event");
        SimpleRecordSchema rootSchema = fullSchema;
        return rootSchema;
    }

    private String getContent() throws XMLStreamException {
        StringBuilder content = new StringBuilder();
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isCharacters()) {
                Characters characters = xmlEvent.asCharacters();
                if (characters.isWhiteSpace()) continue;
                content.append(characters.getData());
                continue;
            }
            if (xmlEvent.isEndElement()) break;
            if (!xmlEvent.isStartElement()) continue;
            this.skipElement();
        }
        return content.toString();
    }

    private Record parseRecord(StartElement startElement, RecordSchema schema, boolean coerceTypes, boolean dropUnknown) throws XMLStreamException, MalformedRecordException {
        Optional field;
        HashMap<String, Object> recordValues = new HashMap<String, Object>();
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            String targetFieldName = attribute.getName().toString();
            if (dropUnknown) {
                Optional field2 = schema.getField(targetFieldName);
                if (!field2.isPresent()) continue;
                if (coerceTypes) {
                    DataType dataType = ((RecordField)field2.get()).getDataType();
                    Object value = this.parseStringForType(attribute.getValue(), targetFieldName, dataType);
                    if (value == null) continue;
                    recordValues.put(targetFieldName, value);
                    continue;
                }
                recordValues.put(targetFieldName, attribute.getValue());
                continue;
            }
            if (coerceTypes) {
                field = schema.getField(targetFieldName);
                if (field.isPresent()) {
                    Object value = this.parseStringForType(attribute.getValue(), targetFieldName, ((RecordField)field.get()).getDataType());
                    if (value == null) continue;
                    recordValues.put(targetFieldName, value);
                    continue;
                }
                recordValues.put(targetFieldName, attribute.getValue());
                continue;
            }
            recordValues.put(targetFieldName, attribute.getValue());
        }
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                String name;
                Map<String, Object> namedValue;
                Object value;
                StartElement subStartElement = xmlEvent.asStartElement();
                String fieldName = subStartElement.getName().getLocalPart();
                field = schema.getField(fieldName);
                if (dropUnknown) {
                    if (field.isPresent()) {
                        if (!coerceTypes || (value = this.parseFieldForType(subStartElement, fieldName, ((RecordField)field.get()).getDataType(), recordValues, true)) == null) continue;
                        recordValues.put(fieldName, value);
                        continue;
                    }
                    if (DATA_TAG.equals(fieldName)) {
                        namedValue = this.parseDataField(subStartElement, schema, true);
                        if (namedValue == null || namedValue.isEmpty()) continue;
                        name = namedValue.keySet().iterator().next();
                        recordValues.put(name, namedValue.get(name));
                        continue;
                    }
                    this.skipElement();
                    continue;
                }
                if (coerceTypes) {
                    if (field.isPresent()) {
                        value = this.parseFieldForType(subStartElement, fieldName, ((RecordField)field.get()).getDataType(), recordValues, false);
                        if (value == null) continue;
                        recordValues.put(fieldName, value);
                        continue;
                    }
                    if (!DATA_TAG.equals(fieldName) || (namedValue = this.parseDataField(subStartElement, schema, dropUnknown)) == null || namedValue.isEmpty()) continue;
                    name = namedValue.keySet().iterator().next();
                    recordValues.put(name, namedValue.get(name));
                    continue;
                }
                if (!DATA_TAG.equals(fieldName) || (namedValue = this.parseDataField(subStartElement, schema, dropUnknown)) == null || namedValue.isEmpty()) continue;
                name = namedValue.keySet().iterator().next();
                recordValues.put(name, namedValue.get(name));
                continue;
            }
            if (!xmlEvent.isEndElement()) continue;
            break;
        }
        for (Map.Entry entry : recordValues.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            recordValues.put((String)entry.getKey(), ((List)entry.getValue()).toArray());
        }
        if (recordValues.size() > 0) {
            return new MapRecord(schema, recordValues);
        }
        return null;
    }

    private Object parseStringForType(String data, String fieldName, DataType dataType) {
        switch (dataType.getFieldType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return DataTypeUtils.convertType((Object)data, (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
            }
        }
        return null;
    }

    private Object parseFieldForType(StartElement startElement, String fieldName, DataType dataType, Map<String, Object> recordValues, boolean dropUnknown) throws XMLStreamException, MalformedRecordException {
        switch (dataType.getFieldType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                StringBuilder content = new StringBuilder();
                while (this.xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
                    if (xmlEvent.isCharacters()) {
                        Characters characters = xmlEvent.asCharacters();
                        if (characters.isWhiteSpace()) continue;
                        content.append(characters.getData());
                        continue;
                    }
                    if (xmlEvent.isEndElement()) {
                        String contentToReturn = content.toString();
                        if (!StringUtils.isBlank((String)contentToReturn)) {
                            return DataTypeUtils.convertType((Object)content.toString(), (DataType)dataType, this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)fieldName);
                        }
                        return null;
                    }
                    if (!xmlEvent.isStartElement()) continue;
                    this.skipElement();
                }
                break;
            }
            case RECORD: {
                if (!(dataType instanceof RecordDataType)) {
                    return null;
                }
                RecordSchema childSchema = ((RecordDataType)dataType).getChildSchema();
                return this.parseRecord(startElement, childSchema, true, dropUnknown);
            }
        }
        return null;
    }

    private Map<String, Object> parseDataField(StartElement startElement, RecordSchema schema, boolean dropUnknown) throws XMLStreamException {
        String dataFieldName;
        String content = this.getContent();
        Iterator<Attribute> iterator = startElement.getAttributes();
        if (!iterator.hasNext()) {
            dataFieldName = content;
            this.setNextRecordStartTag();
            String eventDataElementName = this.currentRecordStartTag.getName().getLocalPart();
            if (!BINARY_TAG.equals(eventDataElementName)) {
                throw new XMLStreamException("Expecting <Binary> tag containing data for element: " + dataFieldName);
            }
            content = this.getContent();
        } else {
            Attribute attribute = iterator.next();
            String attributeName = attribute.getName().getLocalPart();
            if (!"Name".equals(attributeName)) {
                throw new XMLStreamException("Expecting 'Name' attribute, actual: " + attributeName);
            }
            dataFieldName = attribute.getValue();
        }
        Optional rf = schema.getField(dataFieldName);
        if (rf.isPresent()) {
            return Collections.singletonMap(dataFieldName, DataTypeUtils.convertType((Object)content, (DataType)((RecordField)rf.get()).getDataType(), this.LAZY_DATE_FORMAT, this.LAZY_TIME_FORMAT, this.LAZY_TIMESTAMP_FORMAT, (String)dataFieldName));
        }
        if (dropUnknown) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(dataFieldName, content);
    }

    static {
        PROVIDER_GUID_FIELD = new RecordField("Guid", RecordFieldType.STRING.getDataType(), false);
        PROVIDER_NAME_FIELD = new RecordField("Name", RecordFieldType.STRING.getDataType(), false);
        TIME_CREATED_SYSTEMTIME_FIELD = new RecordField("SystemTime", RecordFieldType.STRING.getDataType(), false);
        EXECUTION_THREADID_FIELD = new RecordField("ThreadID", RecordFieldType.INT.getDataType(), true);
        EXECUTION_PROCESSID_FIELD = new RecordField("ProcessID", RecordFieldType.INT.getDataType(), true);
        EVENT_ID_FIELD = new RecordField("EventID", RecordFieldType.INT.getDataType(), true);
        VERSION_FIELD = new RecordField("Version", RecordFieldType.INT.getDataType(), true);
        LEVEL_FIELD = new RecordField("Level", RecordFieldType.INT.getDataType(), true);
        TASK_FIELD = new RecordField("Task", RecordFieldType.INT.getDataType(), true);
        OPCODE_FIELD = new RecordField("Opcode", RecordFieldType.INT.getDataType(), true);
        KEYWORDS_FIELD = new RecordField("Keywords", RecordFieldType.STRING.getDataType(), true);
        EVENTRECORDID_FIELD = new RecordField("EventRecordID", RecordFieldType.INT.getDataType(), true);
        CORRELATION_FIELD = new RecordField("Correlation", RecordFieldType.STRING.getDataType(), true);
        CHANNEL_FIELD = new RecordField("Channel", RecordFieldType.STRING.getDataType(), true);
        COMPUTER_FIELD = new RecordField("Computer", RecordFieldType.STRING.getDataType(), true);
        SECURITY_FIELD = new RecordField("Security", RecordFieldType.STRING.getDataType(), true);
        ArrayList<RecordField> systemProviderFields = new ArrayList<RecordField>();
        systemProviderFields.add(PROVIDER_GUID_FIELD);
        systemProviderFields.add(PROVIDER_NAME_FIELD);
        SimpleRecordSchema systemProviderSchema = new SimpleRecordSchema(systemProviderFields);
        systemProviderSchema.setSchemaName("Provider");
        ArrayList<RecordField> systemTimeCreatedFields = new ArrayList<RecordField>(1);
        systemTimeCreatedFields.add(TIME_CREATED_SYSTEMTIME_FIELD);
        SimpleRecordSchema systemTimeCreatedSchema = new SimpleRecordSchema(systemTimeCreatedFields);
        systemTimeCreatedSchema.setSchemaName("TimeCreated");
        ArrayList<RecordField> systemExecutionFields = new ArrayList<RecordField>(2);
        systemExecutionFields.add(EXECUTION_THREADID_FIELD);
        systemExecutionFields.add(EXECUTION_PROCESSID_FIELD);
        SimpleRecordSchema systemExecutionSchema = new SimpleRecordSchema(systemExecutionFields);
        systemExecutionSchema.setSchemaName("Execution");
        ArrayList<RecordField> systemFields = new ArrayList<RecordField>(14);
        systemFields.add(new RecordField("Provider", RecordFieldType.RECORD.getRecordDataType((RecordSchema)systemProviderSchema)));
        systemFields.add(EVENT_ID_FIELD);
        systemFields.add(VERSION_FIELD);
        systemFields.add(LEVEL_FIELD);
        systemFields.add(TASK_FIELD);
        systemFields.add(OPCODE_FIELD);
        systemFields.add(KEYWORDS_FIELD);
        systemFields.add(new RecordField("TimeCreated", RecordFieldType.RECORD.getRecordDataType((RecordSchema)systemTimeCreatedSchema)));
        systemFields.add(EVENTRECORDID_FIELD);
        systemFields.add(CORRELATION_FIELD);
        systemFields.add(new RecordField("Execution", RecordFieldType.RECORD.getRecordDataType((RecordSchema)systemExecutionSchema)));
        systemFields.add(CHANNEL_FIELD);
        systemFields.add(COMPUTER_FIELD);
        systemFields.add(SECURITY_FIELD);
        SYSTEM_SCHEMA = new SimpleRecordSchema(systemFields);
        SYSTEM_SCHEMA.setSchemaName("System");
    }
}

