/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.inference;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.nifi.schema.inference.HierarchicalSchemaInference;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.util.SchemaInferenceUtil;
import org.apache.nifi.xml.inference.XmlArrayNode;
import org.apache.nifi.xml.inference.XmlContainerNode;
import org.apache.nifi.xml.inference.XmlNode;
import org.apache.nifi.xml.inference.XmlNodeType;
import org.apache.nifi.xml.inference.XmlTextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSchemaInference
extends HierarchicalSchemaInference<XmlNode> {
    private static final Logger logger = LoggerFactory.getLogger(XmlSchemaInference.class);
    private final TimeValueInference timeValueInference;

    public XmlSchemaInference(TimeValueInference timeValueInference) {
        this.timeValueInference = timeValueInference;
    }

    protected DataType getDataType(XmlNode xmlNode) {
        XmlNodeType nodeType = xmlNode.getNodeType();
        if (nodeType != XmlNodeType.TEXT) {
            logger.debug("When inferring XML Schema, expected to get an XmlTextNode but received a {} node instead; will ignore this node.", (Object)nodeType);
            return null;
        }
        String text = ((XmlTextNode)xmlNode).getText();
        return this.inferTextualDataType(text);
    }

    public DataType inferTextualDataType(String text) {
        return SchemaInferenceUtil.getDataType((String)text, (TimeValueInference)this.timeValueInference);
    }

    protected boolean isObject(XmlNode value) {
        return value.getNodeType() == XmlNodeType.CONTAINER;
    }

    protected boolean isArray(XmlNode value) {
        return value.getNodeType() == XmlNodeType.ARRAY;
    }

    protected boolean isEmptyArray(XmlNode value) {
        return value.getNodeType() == XmlNodeType.ARRAY && ((XmlArrayNode)value).getElements().isEmpty();
    }

    protected void forEachFieldInRecord(XmlNode rawRecord, BiConsumer<String, XmlNode> fieldConsumer) {
        XmlContainerNode container = (XmlContainerNode)rawRecord;
        container.forEach(fieldConsumer);
    }

    protected void forEachRawRecordInArray(XmlNode arrayRecord, Consumer<XmlNode> rawRecordConsumer) {
        XmlArrayNode arrayNode = (XmlArrayNode)arrayRecord;
        arrayNode.forEach(rawRecordConsumer);
    }

    protected String getRootName(XmlNode rawRecord) {
        return rawRecord.getName();
    }
}

