/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.SchemaRegistryRecordSetWriter;

public abstract class DateTimeTextRecordSetWriter
extends SchemaRegistryRecordSetWriter {
    private volatile Optional<String> dateFormat;
    private volatile Optional<String> timeFormat;
    private volatile Optional<String> timestampFormat;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(DateTimeUtils.DATE_FORMAT);
        properties.add(DateTimeUtils.TIME_FORMAT);
        properties.add(DateTimeUtils.TIMESTAMP_FORMAT);
        return properties;
    }

    @OnEnabled
    public void captureValues(ConfigurationContext context) {
        this.dateFormat = Optional.ofNullable(context.getProperty(DateTimeUtils.DATE_FORMAT).getValue());
        this.timeFormat = Optional.ofNullable(context.getProperty(DateTimeUtils.TIME_FORMAT).getValue());
        this.timestampFormat = Optional.ofNullable(context.getProperty(DateTimeUtils.TIMESTAMP_FORMAT).getValue());
    }

    protected Optional<String> getDateFormat() {
        return this.dateFormat;
    }

    protected Optional<String> getTimeFormat() {
        return this.timeFormat;
    }

    protected Optional<String> getTimestampFormat() {
        return this.timestampFormat;
    }
}

