/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.json;

import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.json.AbstractJsonRowRecordReader;
import org.apache.nifi.json.JsonParserFactory;
import org.apache.nifi.json.JsonPathReader;
import org.apache.nifi.json.JsonRecordSource;
import org.apache.nifi.json.JsonSchemaInference;
import org.apache.nifi.json.JsonTreeRowRecordReader;
import org.apache.nifi.json.SchemaApplicationStrategy;
import org.apache.nifi.json.StartingFieldStrategy;
import org.apache.nifi.json.TokenParserFactory;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schema.inference.RecordSourceFactory;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.schema.inference.SchemaInferenceUtil;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.DateTimeUtils;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"json", "tree", "record", "reader", "parser"})
@CapabilityDescription(value="Parses JSON into individual Record objects. While the reader expects each record to be well-formed JSON, the content of a FlowFile may consist of many records, each as a well-formed JSON array or JSON object with optional whitespace between them, such as the common 'JSON-per-line' format. If an array is encountered, each element in that array will be treated as a separate record. If the schema that is configured contains a field that is not present in the JSON, a null value will be used. If the JSON contains a field that is not present in the schema, that field will be skipped. See the Usage of the Controller Service for more information and examples.")
@SeeAlso(value={JsonPathReader.class})
public class JsonTreeReader
extends SchemaRegistryService
implements RecordReaderFactory {
    protected volatile String dateFormat;
    protected volatile String timeFormat;
    protected volatile String timestampFormat;
    protected volatile String startingFieldName;
    protected volatile StartingFieldStrategy startingFieldStrategy;
    protected volatile SchemaApplicationStrategy schemaApplicationStrategy;
    private volatile boolean allowComments;
    private volatile StreamReadConstraints streamReadConstraints;
    public static final PropertyDescriptor STARTING_FIELD_STRATEGY = new PropertyDescriptor.Builder().name("starting-field-strategy").displayName("Starting Field Strategy").description("Start processing from the root node or from a specified nested node.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue(StartingFieldStrategy.ROOT_NODE.getValue()).allowableValues(StartingFieldStrategy.class).build();
    public static final PropertyDescriptor STARTING_FIELD_NAME = new PropertyDescriptor.Builder().name("starting-field-name").displayName("Starting Field Name").description("Skips forward to the given nested JSON field (array or object) to begin processing.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue(null).dependsOn(STARTING_FIELD_STRATEGY, StartingFieldStrategy.NESTED_FIELD.name(), new String[0]).build();
    public static final PropertyDescriptor SCHEMA_APPLICATION_STRATEGY = new PropertyDescriptor.Builder().name("schema-application-strategy").displayName("Schema Application Strategy").description("Specifies whether the schema is defined for the whole JSON or for the selected part starting from \"Starting Field Name\".").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue(SchemaApplicationStrategy.SELECTED_PART.getValue()).dependsOn(STARTING_FIELD_STRATEGY, StartingFieldStrategy.NESTED_FIELD.name(), new String[0]).dependsOn(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, new AllowableValue[]{SchemaAccessUtils.SCHEMA_NAME_PROPERTY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY, SchemaAccessUtils.HWX_SCHEMA_REF_ATTRIBUTES, SchemaAccessUtils.HWX_CONTENT_ENCODED_SCHEMA, SchemaAccessUtils.CONFLUENT_ENCODED_SCHEMA}).allowableValues(SchemaApplicationStrategy.class).build();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(new PropertyDescriptor.Builder().fromPropertyDescriptor(SchemaInferenceUtil.SCHEMA_CACHE).dependsOn(SchemaAccessUtils.SCHEMA_ACCESS_STRATEGY, new AllowableValue[]{SchemaInferenceUtil.INFER_SCHEMA}).build());
        properties.add(STARTING_FIELD_STRATEGY);
        properties.add(STARTING_FIELD_NAME);
        properties.add(SCHEMA_APPLICATION_STRATEGY);
        properties.add(AbstractJsonRowRecordReader.MAX_STRING_LENGTH);
        properties.add(AbstractJsonRowRecordReader.ALLOW_COMMENTS);
        properties.add(DateTimeUtils.DATE_FORMAT);
        properties.add(DateTimeUtils.TIME_FORMAT);
        properties.add(DateTimeUtils.TIMESTAMP_FORMAT);
        return properties;
    }

    @OnEnabled
    public void storePropertyValues(ConfigurationContext context) {
        this.dateFormat = context.getProperty(DateTimeUtils.DATE_FORMAT).getValue();
        this.timeFormat = context.getProperty(DateTimeUtils.TIME_FORMAT).getValue();
        this.timestampFormat = context.getProperty(DateTimeUtils.TIMESTAMP_FORMAT).getValue();
        this.startingFieldStrategy = StartingFieldStrategy.valueOf((String)context.getProperty(STARTING_FIELD_STRATEGY).getValue());
        this.startingFieldName = context.getProperty(STARTING_FIELD_NAME).getValue();
        this.schemaApplicationStrategy = SchemaApplicationStrategy.valueOf((String)context.getProperty(SCHEMA_APPLICATION_STRATEGY).getValue());
        this.streamReadConstraints = this.buildStreamReadConstraints(context);
        this.allowComments = this.isAllowCommentsEnabled(context);
    }

    protected StreamReadConstraints buildStreamReadConstraints(ConfigurationContext context) {
        int maxStringLength = context.getProperty(AbstractJsonRowRecordReader.MAX_STRING_LENGTH).asDataSize(DataUnit.B).intValue();
        return StreamReadConstraints.builder().maxStringLength(maxStringLength).build();
    }

    protected boolean isAllowCommentsEnabled(ConfigurationContext context) {
        return context.getProperty(AbstractJsonRowRecordReader.ALLOW_COMMENTS).asBoolean();
    }

    protected List<AllowableValue> getSchemaAccessStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(SchemaInferenceUtil.INFER_SCHEMA);
        allowableValues.addAll(super.getSchemaAccessStrategyValues());
        return allowableValues;
    }

    protected SchemaAccessStrategy getSchemaAccessStrategy(String schemaAccessStrategy, SchemaRegistry schemaRegistry, PropertyContext context) {
        RecordSourceFactory<JsonNode> jsonSourceFactory = this.createJsonRecordSourceFactory();
        Supplier<SchemaInferenceEngine> inferenceSupplier = () -> new JsonSchemaInference(new TimeValueInference(this.dateFormat, this.timeFormat, this.timestampFormat));
        return SchemaInferenceUtil.getSchemaAccessStrategy((String)schemaAccessStrategy, (PropertyContext)context, (ComponentLog)this.getLogger(), jsonSourceFactory, inferenceSupplier, () -> super.getSchemaAccessStrategy(schemaAccessStrategy, schemaRegistry, context));
    }

    protected RecordSourceFactory<JsonNode> createJsonRecordSourceFactory() {
        return (variables, in) -> new JsonRecordSource(in, this.startingFieldStrategy, this.startingFieldName);
    }

    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return SchemaInferenceUtil.INFER_SCHEMA;
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, long inputLength, ComponentLog logger) throws IOException, MalformedRecordException, SchemaNotFoundException {
        RecordSchema schema = this.getSchema(variables, in, null);
        return this.createJsonTreeRowRecordReader(in, logger, schema);
    }

    protected JsonTreeRowRecordReader createJsonTreeRowRecordReader(InputStream in, ComponentLog logger, RecordSchema schema) throws IOException, MalformedRecordException {
        return new JsonTreeRowRecordReader(in, logger, schema, this.dateFormat, this.timeFormat, this.timestampFormat, this.startingFieldStrategy, this.startingFieldName, this.schemaApplicationStrategy, null, this.allowComments, this.streamReadConstraints, (TokenParserFactory)new JsonParserFactory());
    }
}

