/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.avro.WriteAvroResultWithExternalSchema;
import org.apache.nifi.avro.WriteAvroResultWithSchema;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SchemaRegistryRecordSetWriter;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"avro", "result", "set", "writer", "serializer", "record", "recordset", "row"})
@CapabilityDescription(value="Writes the contents of a RecordSet in Binary Avro format.")
public class AvroRecordSetWriter
extends SchemaRegistryRecordSetWriter
implements RecordSetWriterFactory {
    private static final Set<SchemaField> requiredSchemaFields = EnumSet.of(SchemaField.SCHEMA_TEXT, SchemaField.SCHEMA_TEXT_FORMAT);
    private static final int MAX_AVRO_SCHEMA_CACHE_SIZE = 20;
    private final Map<String, Schema> compiledAvroSchemaCache = new LinkedHashMap<String, Schema>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Schema> eldest) {
            return this.size() >= 20;
        }
    };
    static final AllowableValue AVRO_EMBEDDED = new AllowableValue("avro-embedded", "Embed Avro Schema", "The FlowFile will have the Avro schema embedded into the content, as is typical with Avro");

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema recordSchema, FlowFile flowFile, OutputStream out) throws IOException {
        String strategyValue = this.getConfigurationContext().getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        try {
            Schema avroSchema;
            try {
                Optional textOption;
                avroSchema = recordSchema.getSchemaFormat().isPresent() & ((String)recordSchema.getSchemaFormat().get()).equals("avro") ? ((textOption = recordSchema.getSchemaText()).isPresent() ? this.compileAvroSchema((String)textOption.get()) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema)) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema);
            }
            catch (Exception e) {
                throw new SchemaNotFoundException("Failed to compile Avro Schema", (Throwable)e);
            }
            if (AVRO_EMBEDDED.getValue().equals(strategyValue)) {
                return new WriteAvroResultWithSchema(avroSchema, out);
            }
            return new WriteAvroResultWithExternalSchema(avroSchema, recordSchema, this.getSchemaAccessWriter(recordSchema), out);
        }
        catch (SchemaNotFoundException e) {
            throw new ProcessException("Could not determine the Avro Schema to use for writing the content", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema compileAvroSchema(String text) {
        Schema compiled;
        AvroRecordSetWriter avroRecordSetWriter = this;
        synchronized (avroRecordSetWriter) {
            compiled = this.compiledAvroSchemaCache.get(text);
        }
        if (compiled != null) {
            return compiled;
        }
        Schema newlyCompiled = new Schema.Parser().parse(text);
        AvroRecordSetWriter avroRecordSetWriter2 = this;
        synchronized (avroRecordSetWriter2) {
            return this.compiledAvroSchemaCache.computeIfAbsent(text, t -> newlyCompiled);
        }
    }

    @Override
    protected List<AllowableValue> getSchemaWriteStrategyValues() {
        ArrayList<AllowableValue> allowableValues = new ArrayList<AllowableValue>();
        allowableValues.add(AVRO_EMBEDDED);
        allowableValues.addAll(super.getSchemaWriteStrategyValues());
        return allowableValues;
    }

    @Override
    protected AllowableValue getDefaultSchemaWriteStrategy() {
        return AVRO_EMBEDDED;
    }

    @Override
    protected Set<SchemaField> getRequiredSchemaFields(ValidationContext validationContext) {
        String writeStrategyValue = validationContext.getProperty(this.getSchemaWriteStrategyDescriptor()).getValue();
        if (writeStrategyValue.equalsIgnoreCase(AVRO_EMBEDDED.getValue())) {
            return requiredSchemaFields;
        }
        return super.getRequiredSchemaFields(validationContext);
    }
}

